/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import org.jphototagger.lib.util.logging.ExceptionLogfileRecord;

public final class LogfileRecord {
    private String date;
    private Long millis;
    private String sequence;
    private String logger;
    private Level level;
    private String classname;
    private String methodname;
    private String thread;
    private String message;
    private String key;
    private String catalog;
    private ExceptionLogfileRecord exception;
    private List<String> params;

    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public Long getMillis() {
        return this.millis;
    }

    public void setMillis(Long millis) {
        this.millis = millis;
    }

    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = Level.parse(level);
    }

    public String getLogger() {
        return this.logger;
    }

    public void setLogger(String logger) {
        this.logger = logger;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMethodname() {
        return this.methodname;
    }

    public void setMethodname(String methodname) {
        this.methodname = methodname;
    }

    public void setMillis(long millis) {
        this.millis = millis;
    }

    public String getSequence() {
        return this.sequence;
    }

    public void setSequence(String sequence) {
        this.sequence = sequence;
    }

    public String getThread() {
        return this.thread;
    }

    public void setThread(String thread) {
        this.thread = thread;
    }

    public List<String> getParams() {
        return Collections.unmodifiableList(this.params);
    }

    public void setParams(List<String> params) {
        this.params = new ArrayList<String>(params);
    }

    public void addParam(String param) {
        if (param == null) {
            throw new NullPointerException("param == null");
        }
        if (this.params == null) {
            this.params = new ArrayList<String>();
        }
        this.params.add(param);
    }

    public ExceptionLogfileRecord getException() {
        return this.exception;
    }

    public void setException(ExceptionLogfileRecord ex) {
        this.exception = ex;
    }

    public boolean hasLogger() {
        return this.logger != null;
    }

    public boolean hasClassname() {
        return this.classname != null;
    }

    public boolean hasMethodname() {
        return this.methodname != null;
    }

    public boolean hasThread() {
        return this.thread != null;
    }

    public boolean hasKey() {
        return this.key != null;
    }

    public boolean hasCatalog() {
        return this.catalog != null;
    }

    public boolean hasParams() {
        return this.params != null;
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public boolean contains(String substring) {
        if (substring == null) {
            throw new NullPointerException("substring == null");
        }
        return this.containsSubstring(this.getMessage(), substring) || this.containsSubstring(this.getClassname(), substring) || this.containsSubstring(this.getMethodname(), substring) || this.containsSubstring(this.getDate(), substring) || this.containsSubstring(this.getLogger(), substring) || this.containsSubstring(this.getSequence(), substring) || this.containsSubstring(this.getThread(), substring) || this.hasException() && this.getException().contains(substring);
    }

    private boolean containsSubstring(String string, String substring) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains(substring.toLowerCase());
    }
}

