/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util.logging;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jphototagger.lib.util.logging.ExceptionLogfileRecord;
import org.jphototagger.lib.util.logging.FrameLogfileRecord;
import org.jphototagger.lib.util.logging.LogfileRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class LogfileParser
implements EntityResolver {
    public static List<LogfileRecord> parseLogfile(String filename) {
        if (filename == null) {
            throw new NullPointerException("filename == null");
        }
        ArrayList<LogfileRecord> records = new ArrayList<LogfileRecord>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setEntityResolver(new LogfileParser());
            Document document = builder.parse(LogfileParser.getFileAsInputStream(filename));
            NodeList recordNodeList = document.getElementsByTagName("record");
            int recordCount = recordNodeList.getLength();
            for (int index = 0; index < recordCount; ++index) {
                Node recordNode = recordNodeList.item(index);
                if (recordNode.getNodeType() != 1) continue;
                LogfileRecord record = new LogfileRecord();
                record.setDate(LogfileParser.getContentOfChildElement(recordNode, "date"));
                record.setMillis(new Long(LogfileParser.getContentOfChildElement(recordNode, "millis")));
                record.setSequence(LogfileParser.getContentOfChildElement(recordNode, "sequence"));
                record.setLogger(LogfileParser.getContentOfChildElement(recordNode, "logger"));
                record.setLevel(LogfileParser.getContentOfChildElement(recordNode, "level"));
                record.setClassname(LogfileParser.getContentOfChildElement(recordNode, "class"));
                record.setMethodname(LogfileParser.getContentOfChildElement(recordNode, "method"));
                record.setThread(LogfileParser.getContentOfChildElement(recordNode, "thread"));
                record.setMessage(LogfileParser.getContentOfChildElement(recordNode, "message"));
                record.setKey(LogfileParser.getContentOfChildElement(recordNode, "key"));
                record.setCatalog(LogfileParser.getContentOfChildElement(recordNode, "catalog"));
                LogfileParser.setException(record, recordNode);
                LogfileParser.setParams(record, recordNode);
                records.add(record);
            }
        }
        catch (Throwable t) {
            Logger.getLogger(LogfileParser.class.getName()).log(Level.SEVERE, null, t);
        }
        return records;
    }

    private static void setException(LogfileRecord record, Node recordNode) {
        NodeList nodeList = ((Element)recordNode).getElementsByTagName("exception");
        if (nodeList != null && nodeList.getLength() == 1) {
            Node exceptionNode = nodeList.item(0);
            if (recordNode.getNodeType() == 1) {
                ExceptionLogfileRecord ex = new ExceptionLogfileRecord();
                ex.setMessage(LogfileParser.getContentOfChildElement(exceptionNode, "message"));
                LogfileParser.setFrames(ex, exceptionNode);
                record.setException(ex);
            }
        }
    }

    private static void setFrames(ExceptionLogfileRecord ex, Node exceptionNode) {
        NodeList nodeList = ((Element)exceptionNode).getElementsByTagName("frame");
        if (nodeList != null) {
            int nodeCount = nodeList.getLength();
            for (int index = 0; index < nodeCount; ++index) {
                Node node = nodeList.item(index);
                if (node.getNodeType() != 1) continue;
                FrameLogfileRecord frame = new FrameLogfileRecord();
                frame.setClassName(LogfileParser.getContentOfChildElement(node, "class"));
                frame.setLine(LogfileParser.getContentOfChildElement(node, "line"));
                frame.setMethodName(LogfileParser.getContentOfChildElement(node, "method"));
                ex.addFrame(frame);
            }
        }
    }

    private static void setParams(LogfileRecord record, Node recordNode) {
        NodeList nodeList = ((Element)recordNode).getElementsByTagName("param");
        if (nodeList != null) {
            int count = nodeList.getLength();
            for (int index = 0; index < count; ++index) {
                String param;
                Node node = nodeList.item(index);
                if (node.getNodeType() != 1 || (param = LogfileParser.getContentOfChildElement(node, "param")) == null) continue;
                record.addParam(param);
            }
        }
    }

    private static String getContentOfChildElement(Node recordNode, String tagName) {
        Node elementNode;
        NodeList childNodeList;
        Element firstElement;
        String elementData = null;
        NodeList nodeList = ((Element)recordNode).getElementsByTagName(tagName);
        if (nodeList != null && (firstElement = (Element)nodeList.item(0)) != null && (childNodeList = firstElement.getChildNodes()) != null && (elementNode = childNodeList.item(0)) != null) {
            elementData = elementNode.getNodeValue().trim();
        }
        return elementData;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputStream stream = null;
        if (systemId.endsWith("logger.dtd")) {
            stream = EntityResolver.class.getResourceAsStream("/org/jphototagger/lib/util/logging/logger.dtd");
        }
        return new InputSource(new InputStreamReader(stream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InputStream getFileAsInputStream(String filename) {
        assert (filename != null);
        BufferedReader bufferedReader = null;
        try {
            String line;
            bufferedReader = new BufferedReader(new FileReader(filename));
            StringBuilder sb = new StringBuilder(1000);
            while ((line = bufferedReader.readLine()) != null) {
                sb.append(line);
            }
            String content = sb.toString();
            if (!content.endsWith("</log>")) {
                content = content + "</log>";
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content.getBytes(System.getProperty("file.encoding")));
            return byteArrayInputStream;
        }
        catch (Throwable t) {
            Logger.getLogger(LogfileParser.class.getName()).log(Level.SEVERE, null, t);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Throwable t) {
                Logger.getLogger(LogfileParser.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return null;
    }

    private LogfileParser() {
    }
}

