/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util.logging;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.XMLFormatter;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumnModel;
import javax.swing.text.html.HTMLDocument;
import org.bushe.swing.event.annotation.AnnotationProcessor;
import org.bushe.swing.event.annotation.EventSubscriber;
import org.jphototagger.lib.api.LookAndFeelChangedEvent;
import org.jphototagger.lib.awt.DesktopUtil;
import org.jphototagger.lib.io.FileUtil;
import org.jphototagger.lib.swing.Dialog;
import org.jphototagger.lib.swing.MessageDisplayer;
import org.jphototagger.lib.swing.TextComponentSearchPanel;
import org.jphototagger.lib.util.Bundle;
import org.jphototagger.lib.util.logging.ExceptionLogfileRecord;
import org.jphototagger.lib.util.logging.FrameLogfileRecord;
import org.jphototagger.lib.util.logging.LogfileDialogTableCellRenderer;
import org.jphototagger.lib.util.logging.LogfileParser;
import org.jphototagger.lib.util.logging.LogfileRecord;
import org.jphototagger.lib.util.logging.LogfileRecordComparatorDescendingByTime;
import org.jphototagger.lib.util.logging.LogfilesTableModel;

public final class LogfileDialog
extends Dialog
implements ListSelectionListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    public static final long DEFAULT_MAX_BYTES = 0xA00000L;
    private static final float MEGABYTE_IN_BYTES = 1048576.0f;
    private long maxBytes = 0xA00000L;
    private final Map<JCheckBox, Level> levelOfCheckBox = new HashMap<JCheckBox, Level>();
    private final Map<JCheckBox, JLabel> iconLabelOfCheckBox = new HashMap<JCheckBox, JLabel>();
    private final Map<Class<?>, Integer> paneIndexOfFormatterClass = new HashMap();
    private final List<Level> visibleLevels = new ArrayList<Level>();
    private String filterString;
    private List<LogfileRecord> logfileRecords;
    private Class<?> formatterClass;
    private String logfilename;
    private JButton buttonExit;
    private JButton buttonReload;
    private JCheckBox checkBoxConfig;
    private JCheckBox checkBoxFine;
    private JCheckBox checkBoxFiner;
    private JCheckBox checkBoxFinest;
    private JCheckBox checkBoxInfo;
    private JCheckBox checkBoxSevere;
    private JCheckBox checkBoxWarning;
    private JLabel labelIconConfig;
    private JLabel labelIconFine;
    private JLabel labelIconFiner;
    private JLabel labelIconFinest;
    private JLabel labelIconInfo;
    private JLabel labelIconSevere;
    private JLabel labelIconWarning;
    private JLabel labelLogfileName;
    private JLabel labelSearch;
    private JPanel panelButtons;
    private JPanel panelCards;
    private JPanel panelContent;
    private JPanel panelFilter;
    private JPanel panelFilterCheckBoxes;
    private TextComponentSearchPanel panelSearchSimple;
    private JPanel panelSearchXml;
    private JPanel panelSimple;
    private JPanel panelXml;
    private JScrollPane scrollPanePanelSimple;
    private JScrollPane scrollPaneTableLogfileRecords;
    private JScrollPane scrollPaneTextPaneDetails;
    private JTable tableLogfileRecords;
    private JTextArea textAreaSimple;
    private JTextField textFieldSearch;
    private JTextPane textPaneDetails;

    public LogfileDialog(Frame parent, String logfilename, Class<?> formatterClass) {
        super(parent, false);
        if (logfilename == null) {
            throw new NullPointerException("logfilename == null");
        }
        if (formatterClass == null) {
            throw new NullPointerException("formatterClass == null");
        }
        this.logfilename = logfilename;
        this.formatterClass = formatterClass;
        this.initPaneIndexOfLogfileType();
        this.initComponents();
        this.postInitComponents();
    }

    private void initPaneIndexOfLogfileType() {
        this.paneIndexOfFormatterClass.put(XMLFormatter.class, 0);
        this.paneIndexOfFormatterClass.put(SimpleFormatter.class, 1);
    }

    private void postInitComponents() {
        this.setLogfileNameLabelText();
        this.initTextPaneDetails();
        this.initTableLogfileRecords();
        this.initLevelOfCheckbox();
        this.listenToCheckboxes();
        AnnotationProcessor.process(this);
    }

    private void setLogfileNameLabelText() {
        String pattern = this.labelLogfileName.getText();
        this.labelLogfileName.setText(MessageFormat.format(pattern, this.logfilename));
    }

    private void initTextPaneDetails() {
        this.textPaneDetails.setStyledDocument(new HTMLDocument());
        this.textPaneDetails.setContentType("text/html");
    }

    private void initTableLogfileRecords() {
        this.tableLogfileRecords.getSelectionModel().addListSelectionListener(this);
        this.tableLogfileRecords.getColumnModel().getSelectionModel().addListSelectionListener(this);
        this.tableLogfileRecords.setDefaultRenderer(Object.class, new LogfileDialogTableCellRenderer());
    }

    private void initLevelOfCheckbox() {
        this.levelOfCheckBox.put(this.checkBoxConfig, Level.CONFIG);
        this.levelOfCheckBox.put(this.checkBoxFine, Level.FINE);
        this.levelOfCheckBox.put(this.checkBoxFiner, Level.FINER);
        this.levelOfCheckBox.put(this.checkBoxFinest, Level.FINEST);
        this.levelOfCheckBox.put(this.checkBoxInfo, Level.INFO);
        this.levelOfCheckBox.put(this.checkBoxSevere, Level.SEVERE);
        this.levelOfCheckBox.put(this.checkBoxWarning, Level.WARNING);
        this.iconLabelOfCheckBox.put(this.checkBoxConfig, this.labelIconConfig);
        this.iconLabelOfCheckBox.put(this.checkBoxFine, this.labelIconFine);
        this.iconLabelOfCheckBox.put(this.checkBoxFiner, this.labelIconFiner);
        this.iconLabelOfCheckBox.put(this.checkBoxFinest, this.labelIconFinest);
        this.iconLabelOfCheckBox.put(this.checkBoxInfo, this.labelIconInfo);
        this.iconLabelOfCheckBox.put(this.checkBoxSevere, this.labelIconSevere);
        this.iconLabelOfCheckBox.put(this.checkBoxWarning, this.labelIconWarning);
    }

    private void listenToCheckboxes() {
        Set<JCheckBox> checkBoxes = this.levelOfCheckBox.keySet();
        for (JCheckBox checkBox : checkBoxes) {
            checkBox.addActionListener(this);
        }
    }

    private void reload() {
        boolean simple = SimpleFormatter.class.equals(this.formatterClass);
        if (simple) {
            try {
                this.textAreaSimple.setText(FileUtil.getContentAsString(new File(this.logfilename), "UTF-8"));
            }
            catch (IOException ex) {
                Logger.getLogger(LogfileDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            this.readLogfileRecords();
            this.setTable();
        }
    }

    private void resetVisibeLevels() {
        this.visibleLevels.clear();
        Set<JCheckBox> checkBoxes = this.levelOfCheckBox.keySet();
        for (JCheckBox checkBox : checkBoxes) {
            if (!checkBox.isSelected()) continue;
            this.visibleLevels.add(this.levelOfCheckBox.get(checkBox));
        }
        this.setTable();
        if (this.tableLogfileRecords.getSelectedRow() < 0) {
            this.textPaneDetails.setText("");
        }
    }

    private boolean checkFileSize() {
        File logfile = new File(this.logfilename);
        long logfileBytes = logfile.length();
        if (logfileBytes <= 0L) {
            this.errorMessageEmpty();
            return false;
        }
        if (logfileBytes >= this.maxBytes) {
            this.errorMessageMaxBytes();
            return false;
        }
        return true;
    }

    private void errorMessageEmpty() {
        String message = Bundle.getString(LogfileDialog.class, "LogfileDialog.Error.LogfileIsEmpty", this.logfilename);
        String title = Bundle.getString(LogfileDialog.class, "LogfileDialog.Error.LogfileIsEmpty.Title", new Object[0]);
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    private void errorMessageMaxBytes() {
        File logfile = new File(this.logfilename);
        long logfileBytes = logfile.length();
        int logfileSizeInMegabytes = Math.round((float)logfileBytes / 1048576.0f);
        int maxSizeInMeagbytes = Math.round((float)this.maxBytes / 1048576.0f);
        String message = Bundle.getString(LogfileDialog.class, "LogfileDialog.Error.MaximumSizeExceeded", logfileSizeInMegabytes, maxSizeInMeagbytes);
        if (MessageDisplayer.confirmYesNo(this, message)) {
            DesktopUtil.open(logfile, "LogfileDialog.OpenLogfile");
        }
    }

    public long getMaxBytes() {
        return this.maxBytes;
    }

    public void setMaxBytes(long maxBytes) {
        this.maxBytes = maxBytes;
    }

    public void setFilterableMinIntValue(int intValue) {
        for (JCheckBox levelCheckBox : this.levelOfCheckBox.keySet()) {
            Level level = this.levelOfCheckBox.get(levelCheckBox);
            int levelIntValue = level.intValue();
            if (levelIntValue >= intValue) continue;
            JLabel iconLabel = this.iconLabelOfCheckBox.get(levelCheckBox);
            this.panelFilterCheckBoxes.remove(iconLabel);
            this.panelFilterCheckBoxes.remove(levelCheckBox);
        }
    }

    private void readLogfileRecords() {
        this.flushLoggerHandlers();
        this.logfileRecords = LogfileParser.parseLogfile(this.logfilename);
    }

    private void filterTable() {
        this.filterString = this.textFieldSearch.getText();
        this.setTable();
    }

    private void setColumnWidths() {
        Rectangle bounds = this.scrollPaneTableLogfileRecords.getViewportBorderBounds();
        int width = bounds.width;
        int widthColumn0 = 25;
        int widthColumn1 = 150;
        int widthColumn2 = width - widthColumn0 - widthColumn1;
        if (widthColumn2 > 0) {
            TableColumnModel columnModel = this.tableLogfileRecords.getColumnModel();
            columnModel.getColumn(0).setPreferredWidth(widthColumn0);
            columnModel.getColumn(1).setPreferredWidth(widthColumn1);
            columnModel.getColumn(2).setPreferredWidth(widthColumn2);
        }
    }

    private void showDetails() {
        LogfilesTableModel model = (LogfilesTableModel)this.tableLogfileRecords.getModel();
        int selectedRowIndex = this.tableLogfileRecords.getSelectedRow();
        if (selectedRowIndex >= 0) {
            this.showDetails(model.getLogfileRecord(selectedRowIndex));
        }
    }

    private void showDetails(LogfileRecord logfileRecord) {
        StringBuilder sb = new StringBuilder(1000);
        sb.append("<html>").append("\n<table>");
        this.addDetailTableRow(sb, Bundle.getString(LogfileDialog.class, "LogfileDialog.Info.Loglevel", new Object[0]), logfileRecord.getLevel().getLocalizedName());
        this.addDetailTableRow(sb, Bundle.getString(LogfileDialog.class, "LogfileDialog.Info.Message", new Object[0]), logfileRecord.getMessage());
        this.addDetailTableRow(sb, Bundle.getString(LogfileDialog.class, "LogfileDialog.Info.LoggerClass", new Object[0]), logfileRecord.getLogger());
        this.addDetailTableRow(sb, Bundle.getString(LogfileDialog.class, "LogfileDialog.Info.Class", new Object[0]), logfileRecord.getClassname());
        this.addDetailTableRow(sb, Bundle.getString(LogfileDialog.class, "LogfileDialog.Info.Method", new Object[0]), logfileRecord.getMethodname());
        this.addDetailTableRow(sb, Bundle.getString(LogfileDialog.class, "LogfileDialog.Info.Thread", new Object[0]), logfileRecord.getThread());
        sb.append("\n</table>");
        this.addDetailException(sb, logfileRecord.getException());
        sb.append("\n</html>");
        this.textPaneDetails.setText(sb.toString());
        this.textPaneDetails.moveCaretPosition(0);
    }

    private void addDetailTableRow(StringBuilder sb, String rowHeader, String rowData) {
        if (rowData != null) {
            sb.append("\n\t<tr>").append("\n\t\t<td>").append("<strong>").append(rowHeader).append("</strong>").append("</td>").append("<td><font color=\"#5555aa\">").append(rowData).append("</font></td>").append("\n\t</tr>");
        }
    }

    private void addDetailException(StringBuilder sb, ExceptionLogfileRecord ex) {
        if (ex != null) {
            this.addDetailExceptionMessage(ex, sb);
            sb.append("\n<pre>");
            List<FrameLogfileRecord> frames = ex.getFrames();
            for (FrameLogfileRecord frame : frames) {
                sb.append("\n").append(frame.getClassName()).append(":").append(" ").append(frame.getMethodName()).append(Bundle.getString(LogfileDialog.class, "LogfileDialog.Info.StartLineNumber", new Object[0])).append(frame.getLine()).append(")");
            }
            sb.append("\n</pre>");
        }
    }

    private void addDetailExceptionMessage(ExceptionLogfileRecord exception, StringBuilder sb) {
        String message = exception.getMessage();
        if (message != null) {
            sb.append("\n<br /><font color=\"ff0000\">").append(message).append("</font>");
        }
    }

    private void setTable() {
        if (this.logfilename != null && !this.logfilename.isEmpty()) {
            LogfilesTableModel model = new LogfilesTableModel(this.filterString, this.visibleLevels);
            this.tableLogfileRecords.setModel(model);
            Collections.sort(this.logfileRecords, LogfileRecordComparatorDescendingByTime.INSTANCE);
            model.setRecords(this.logfileRecords);
            this.scrollPaneTableLogfileRecords.getViewport().setViewPosition(new Point(0, 0));
            this.setColumnWidths();
        }
    }

    private void flushLoggerHandlers() {
        Handler[] handlers;
        for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
            handler.flush();
        }
    }

    private boolean isCheckbox(Object source) {
        Set<JCheckBox> checkBoxes = this.levelOfCheckBox.keySet();
        for (JCheckBox checkBox : checkBoxes) {
            if (checkBox != source) continue;
            return true;
        }
        return false;
    }

    @Override
    public void valueChanged(ListSelectionEvent evt) {
        this.showDetails();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.isCheckbox(evt.getSource())) {
            this.resetVisibeLevels();
        }
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible && !this.checkFileSize()) {
            return;
        }
        if (visible) {
            boolean simpleFormatter = this.formatterClass.equals(SimpleFormatter.class);
            boolean xmlFormatter = this.formatterClass.equals(XMLFormatter.class);
            this.panelSearchSimple.setEnabled(simpleFormatter);
            if (xmlFormatter) {
                this.readXml();
                this.panelSearchXml.requestFocusInWindow();
                this.remove(this.panelSearchSimple);
            } else if (simpleFormatter) {
                this.readSimple();
                this.panelSearchSimple.requestFocusToSearchTextField();
            } else {
                this.errorMessageNotSupportedFormat();
                this.readSimple();
            }
        }
        super.setVisible(visible);
    }

    private void errorMessageNotSupportedFormat() {
        String message = Bundle.getString(LogfileDialog.class, "LogfileDialog.Error.UnknownLogfileFormat", new Object[0]);
        String title = Bundle.getString(LogfileDialog.class, "LogfileDialog.Error.UnknownLogfileFormat.Title", new Object[0]);
        JOptionPane.showMessageDialog(this, message, title, 0);
    }

    private void readSimple() {
        this.showCard("panelSimple");
        try {
            this.textAreaSimple.setText(FileUtil.getContentAsString(new File(this.logfilename), "UTF-8"));
        }
        catch (IOException ex) {
            Logger.getLogger(LogfileDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    private void readXml() {
        this.showCard("panelXml");
        this.filterString = this.textFieldSearch.getText();
        this.readLogfileRecords();
        this.resetVisibeLevels();
        this.textFieldSearch.requestFocus();
    }

    private void showCard(String cardName) {
        CardLayout cardLayout = (CardLayout)this.panelCards.getLayout();
        cardLayout.show(this.panelCards, cardName);
    }

    @EventSubscriber(eventClass=LookAndFeelChangedEvent.class)
    public void lookAndFeelChanged(LookAndFeelChangedEvent evt) {
        SwingUtilities.updateComponentTreeUI(this);
    }

    private void initComponents() {
        this.panelContent = new JPanel();
        this.labelLogfileName = new JLabel();
        this.panelButtons = new JPanel();
        this.buttonReload = new JButton();
        this.buttonExit = new JButton();
        this.panelCards = new JPanel();
        this.panelXml = new JPanel();
        this.panelFilter = new JPanel();
        this.panelFilterCheckBoxes = new JPanel();
        this.labelIconSevere = new JLabel();
        this.checkBoxSevere = new JCheckBox();
        this.labelIconWarning = new JLabel();
        this.checkBoxWarning = new JCheckBox();
        this.labelIconInfo = new JLabel();
        this.checkBoxInfo = new JCheckBox();
        this.labelIconConfig = new JLabel();
        this.checkBoxConfig = new JCheckBox();
        this.labelIconFine = new JLabel();
        this.checkBoxFine = new JCheckBox();
        this.labelIconFiner = new JLabel();
        this.checkBoxFiner = new JCheckBox();
        this.labelIconFinest = new JLabel();
        this.checkBoxFinest = new JCheckBox();
        this.panelSearchXml = new JPanel();
        this.labelSearch = new JLabel();
        this.textFieldSearch = new JTextField();
        this.scrollPaneTableLogfileRecords = new JScrollPane();
        this.tableLogfileRecords = new JTable();
        this.scrollPaneTextPaneDetails = new JScrollPane();
        this.textPaneDetails = new JTextPane();
        this.panelSimple = new JPanel();
        this.scrollPanePanelSimple = new JScrollPane();
        this.textAreaSimple = new JTextArea();
        this.panelSearchSimple = new TextComponentSearchPanel();
        this.panelSearchSimple.setSearchableTextComponent(this.textAreaSimple);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/lib/util/logging/Bundle");
        this.setTitle(bundle.getString("LogfileDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LogfileDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.panelContent.setName("panelContent");
        this.panelContent.setLayout(new GridBagLayout());
        this.labelLogfileName.setText(bundle.getString("LogfileDialog.labelLogfileName.text"));
        this.labelLogfileName.setName("labelLogfileName");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelContent.add((Component)this.labelLogfileName, gridBagConstraints);
        this.panelButtons.setName("panelButtons");
        this.panelButtons.setLayout(new GridLayout(1, 0, 10, 0));
        this.buttonReload.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_refresh24.png")));
        this.buttonReload.setToolTipText(bundle.getString("LogfileDialog.buttonReload.toolTipText"));
        this.buttonReload.setBorder(null);
        this.buttonReload.setName("buttonReload");
        this.buttonReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogfileDialog.this.buttonReloadActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonReload);
        this.buttonExit.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_exit24.png")));
        this.buttonExit.setToolTipText(bundle.getString("LogfileDialog.buttonExit.toolTipText"));
        this.buttonExit.setBorder(null);
        this.buttonExit.setName("buttonExit");
        this.buttonExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogfileDialog.this.buttonExitActionPerformed(evt);
            }
        });
        this.panelButtons.add(this.buttonExit);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 10, 0, 0);
        this.panelContent.add((Component)this.panelButtons, gridBagConstraints);
        this.panelCards.setName("panelCards");
        this.panelCards.setLayout(new CardLayout());
        this.panelXml.setName("panelXml");
        this.panelXml.setLayout(new GridBagLayout());
        this.panelFilter.setBorder(BorderFactory.createTitledBorder(bundle.getString("LogfileDialog.panelFilter.border.title")));
        this.panelFilter.setName("panelFilter");
        this.panelFilter.setLayout(new GridBagLayout());
        this.panelFilterCheckBoxes.setName("panelFilterCheckBoxes");
        this.panelFilterCheckBoxes.setLayout(new GridBagLayout());
        this.labelIconSevere.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_logfiledialog_severe.png")));
        this.labelIconSevere.setName("labelIconSevere");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelFilterCheckBoxes.add((Component)this.labelIconSevere, gridBagConstraints);
        this.checkBoxSevere.setSelected(true);
        this.checkBoxSevere.setText(Level.SEVERE.getLocalizedName());
        this.checkBoxSevere.setName("checkBoxSevere");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelFilterCheckBoxes.add((Component)this.checkBoxSevere, gridBagConstraints);
        this.labelIconWarning.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_logfiledialog_warning.png")));
        this.labelIconWarning.setName("labelIconWarning");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelFilterCheckBoxes.add((Component)this.labelIconWarning, gridBagConstraints);
        this.checkBoxWarning.setSelected(true);
        this.checkBoxWarning.setText(Level.WARNING.getLocalizedName());
        this.checkBoxWarning.setName("checkBoxWarning");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelFilterCheckBoxes.add((Component)this.checkBoxWarning, gridBagConstraints);
        this.labelIconInfo.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_logfiledialog_info.png")));
        this.labelIconInfo.setName("labelIconInfo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelFilterCheckBoxes.add((Component)this.labelIconInfo, gridBagConstraints);
        this.checkBoxInfo.setSelected(true);
        this.checkBoxInfo.setText(Level.INFO.getLocalizedName());
        this.checkBoxInfo.setName("checkBoxInfo");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelFilterCheckBoxes.add((Component)this.checkBoxInfo, gridBagConstraints);
        this.labelIconConfig.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_logfiledialog_config.png")));
        this.labelIconConfig.setName("labelIconConfig");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelFilterCheckBoxes.add((Component)this.labelIconConfig, gridBagConstraints);
        this.checkBoxConfig.setSelected(true);
        this.checkBoxConfig.setText(Level.CONFIG.getLocalizedName());
        this.checkBoxConfig.setName("checkBoxConfig");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.panelFilterCheckBoxes.add((Component)this.checkBoxConfig, gridBagConstraints);
        this.labelIconFine.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_logfiledialog_fine.png")));
        this.labelIconFine.setName("labelIconFine");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelFilterCheckBoxes.add((Component)this.labelIconFine, gridBagConstraints);
        this.checkBoxFine.setSelected(true);
        this.checkBoxFine.setText(Level.FINE.getLocalizedName());
        this.checkBoxFine.setName("checkBoxFine");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelFilterCheckBoxes.add((Component)this.checkBoxFine, gridBagConstraints);
        this.labelIconFiner.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_logfiledialog_finer.png")));
        this.labelIconFiner.setName("labelIconFiner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.panelFilterCheckBoxes.add((Component)this.labelIconFiner, gridBagConstraints);
        this.checkBoxFiner.setSelected(true);
        this.checkBoxFiner.setText(Level.FINER.getLocalizedName());
        this.checkBoxFiner.setName("checkBoxFiner");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelFilterCheckBoxes.add((Component)this.checkBoxFiner, gridBagConstraints);
        this.labelIconFinest.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_logfiledialog_finest.png")));
        this.labelIconFinest.setName("labelIconFinest");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 0);
        this.panelFilterCheckBoxes.add((Component)this.labelIconFinest, gridBagConstraints);
        this.checkBoxFinest.setSelected(true);
        this.checkBoxFinest.setText(Level.FINEST.getLocalizedName());
        this.checkBoxFinest.setName("checkBoxFinest");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelFilterCheckBoxes.add((Component)this.checkBoxFinest, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.panelFilter.add((Component)this.panelFilterCheckBoxes, gridBagConstraints);
        this.panelSearchXml.setName("panelSearchXml");
        this.panelSearchXml.setLayout(new GridBagLayout());
        this.labelSearch.setText(bundle.getString("LogfileDialog.labelSearch.text"));
        this.labelSearch.setName("labelSearch");
        this.panelSearchXml.add((Component)this.labelSearch, new GridBagConstraints());
        this.textFieldSearch.setName("textFieldSearch");
        this.textFieldSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                LogfileDialog.this.textFieldSearchKeyReleased(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 0, 0);
        this.panelSearchXml.add((Component)this.textFieldSearch, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.panelFilter.add((Component)this.panelSearchXml, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.panelXml.add((Component)this.panelFilter, gridBagConstraints);
        this.scrollPaneTableLogfileRecords.setName("scrollPaneTableLogfileRecords");
        this.scrollPaneTableLogfileRecords.setPreferredSize(new Dimension(50, 50));
        this.scrollPaneTableLogfileRecords.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                LogfileDialog.this.scrollPaneTableLogfileRecordsComponentResized(evt);
            }
        });
        this.tableLogfileRecords.setAutoCreateRowSorter(true);
        this.tableLogfileRecords.setModel(new LogfilesTableModel("", Arrays.asList(Level.ALL)));
        this.tableLogfileRecords.setAutoResizeMode(0);
        this.tableLogfileRecords.setName("tableLogfileRecords");
        this.tableLogfileRecords.setSelectionMode(0);
        this.scrollPaneTableLogfileRecords.setViewportView(this.tableLogfileRecords);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.6;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelXml.add((Component)this.scrollPaneTableLogfileRecords, gridBagConstraints);
        this.scrollPaneTextPaneDetails.setName("scrollPaneTextPaneDetails");
        this.scrollPaneTextPaneDetails.setPreferredSize(new Dimension(50, 50));
        this.textPaneDetails.setEditable(false);
        this.textPaneDetails.setName("textPaneDetails");
        this.scrollPaneTextPaneDetails.setViewportView(this.textPaneDetails);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.4;
        gridBagConstraints.insets = new Insets(3, 0, 0, 0);
        this.panelXml.add((Component)this.scrollPaneTextPaneDetails, gridBagConstraints);
        this.panelCards.add((Component)this.panelXml, "panelXml");
        this.panelSimple.setName("panelSimple");
        this.panelSimple.setLayout(new GridBagLayout());
        this.scrollPanePanelSimple.setName("scrollPanePanelSimple");
        this.textAreaSimple.setColumns(20);
        this.textAreaSimple.setRows(5);
        this.textAreaSimple.setName("textAreaSimple");
        this.scrollPanePanelSimple.setViewportView(this.textAreaSimple);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.panelSimple.add((Component)this.scrollPanePanelSimple, gridBagConstraints);
        this.panelSearchSimple.setName("panelSearchSimple");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelSimple.add((Component)this.panelSearchSimple, gridBagConstraints);
        this.panelCards.add((Component)this.panelSimple, "panelSimple");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.panelContent.add((Component)this.panelCards, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        this.getContentPane().add((Component)this.panelContent, gridBagConstraints);
        this.pack();
    }

    private void textFieldSearchKeyReleased(KeyEvent evt) {
        this.filterTable();
    }

    private void buttonReloadActionPerformed(ActionEvent evt) {
        this.reload();
    }

    private void buttonExitActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.setVisible(false);
    }

    private void scrollPaneTableLogfileRecordsComponentResized(ComponentEvent evt) {
        this.setColumnWidths();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LogfileDialog dialog = new LogfileDialog((Frame)new JFrame(), "", XMLFormatter.class);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

