/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util.logging;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jphototagger.lib.util.logging.FrameLogfileRecord;

public final class ExceptionLogfileRecord {
    private final List<FrameLogfileRecord> logfileRecordFrames = new ArrayList<FrameLogfileRecord>();
    private String message;

    public List<FrameLogfileRecord> getFrames() {
        return Collections.unmodifiableList(this.logfileRecordFrames);
    }

    public void addFrame(FrameLogfileRecord frame) {
        if (frame == null) {
            throw new NullPointerException("frame == null");
        }
        this.logfileRecordFrames.add(frame);
    }

    public String getMessage() {
        return this.message;
    }

    public boolean hasMessage() {
        return this.message != null;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    boolean contains(String substring) {
        if (substring == null) {
            throw new NullPointerException("substring == null");
        }
        boolean contains = this.containsSubstring(this.getMessage(), substring);
        int count = this.logfileRecordFrames.size();
        for (int index = 0; !contains && count < index; ++index) {
            contains = this.logfileRecordFrames.get(index).contains(substring);
        }
        return contains;
    }

    private boolean containsSubstring(String string, String substring) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().contains(substring.toLowerCase());
    }
}

