/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.text.MessageFormat;
import java.util.StringTokenizer;

public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor1;
    private final int minor2;
    private final int minor3;

    public Version(int major, int minor) {
        this.major = major;
        this.minor1 = minor;
        this.minor2 = 0;
        this.minor3 = 0;
    }

    public Version(int major, int minor1, int minor2) {
        this.major = major;
        this.minor1 = minor1;
        this.minor2 = minor2;
        this.minor3 = 0;
    }

    public Version(int major, int minor1, int minor2, int minor3) {
        this.major = major;
        this.minor1 = minor1;
        this.minor2 = minor2;
        this.minor3 = minor3;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor1() {
        return this.minor1;
    }

    public int getMinor2() {
        return this.minor2;
    }

    public int getMinor3() {
        return this.minor3;
    }

    public static Version parseVersion(String version, String delimiter) throws IllegalArgumentException, NumberFormatException {
        int major = 0;
        int minor1 = 0;
        int minor2 = 0;
        int minor3 = 0;
        StringTokenizer st = new StringTokenizer(version, delimiter);
        int count = st.countTokens();
        if (count < 2 || count > 4) {
            throw new IllegalArgumentException("Invalid count");
        }
        int index = 0;
        while (st.hasMoreTokens()) {
            int number = Integer.parseInt(st.nextToken().trim());
            switch (index) {
                case 0: {
                    major = number;
                    break;
                }
                case 1: {
                    minor1 = number;
                    break;
                }
                case 2: {
                    minor2 = number;
                    break;
                }
                case 3: {
                    minor3 = number;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            ++index;
        }
        return new Version(major, minor1, minor2, minor3);
    }

    @Override
    public int compareTo(Version o) {
        if (this.major > o.major) {
            return 1;
        }
        if (this.major < o.major) {
            return -1;
        }
        if (this.minor1 > o.minor1) {
            return 1;
        }
        if (this.minor1 < o.minor1) {
            return -1;
        }
        if (this.minor2 > o.minor2) {
            return 1;
        }
        if (this.minor2 < o.minor2) {
            return -1;
        }
        if (this.minor3 > o.minor3) {
            return 1;
        }
        if (this.minor3 < o.minor3) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor1 != other.minor1) {
            return false;
        }
        if (this.minor2 != other.minor2) {
            return false;
        }
        return this.minor3 == other.minor3;
    }

    public int hashCode() {
        int hash = 3;
        hash = 97 * hash + this.major;
        hash = 97 * hash + this.minor1;
        hash = 97 * hash + this.minor2;
        hash = 97 * hash + this.minor3;
        return hash;
    }

    public String toString2() {
        return MessageFormat.format("{0}.{1}", this.major, this.minor1);
    }

    public String toString3() {
        return MessageFormat.format("{0}.{1}.{2}", this.major, this.minor1, this.minor2);
    }

    public String toString() {
        return MessageFormat.format("{0}.{1}.{2}.{3}", this.major, this.minor1, this.minor2, this.minor3);
    }
}

