/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.awt.Desktop;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.lib.util.Version;

public final class SystemUtil {
    public static Version getJavaVersion() {
        Version version = null;
        String versionProperty = System.getProperty("java.version");
        StringTokenizer tok = new StringTokenizer(versionProperty, ".");
        if (tok.countTokens() >= 2) {
            try {
                int major = Integer.parseInt(tok.nextToken());
                int minor = Integer.parseInt(tok.nextToken());
                return new Version(major, minor);
            }
            catch (Throwable t) {
                Logger.getLogger(SystemUtil.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return version;
    }

    public static boolean canMail() {
        return SystemUtil.isSupported(Desktop.Action.MAIL);
    }

    public static boolean canBrowse() {
        return SystemUtil.isSupported(Desktop.Action.BROWSE);
    }

    public static boolean canOpen() {
        return SystemUtil.isSupported(Desktop.Action.OPEN);
    }

    public static boolean canEdit() {
        return SystemUtil.isSupported(Desktop.Action.EDIT);
    }

    public static boolean canPrint() {
        return SystemUtil.isSupported(Desktop.Action.PRINT);
    }

    private static boolean isSupported(Desktop.Action action) {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(action);
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("windows");
    }

    public static boolean isLinux() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("linux");
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.contains("mac");
    }

    public static String getDefaultProgramDirPath() {
        if (SystemUtil.isWindows()) {
            String programFiles = System.getenv("ProgramFiles");
            return programFiles == null ? "" : programFiles;
        }
        if (SystemUtil.isLinux()) {
            return "/usr/bin";
        }
        return "";
    }

    public static String guessVmArchitecture() {
        try {
            String arch = System.getProperty("sun.arch.data.model");
            if (arch == null) {
                arch = System.getProperty("os.arch");
            }
            return arch == null ? "" : (arch.contains("64") ? "64" : "32");
        }
        catch (Throwable t) {
            Logger.getLogger(SystemUtil.class.getName()).log(Level.SEVERE, null, t);
            return "";
        }
    }

    private SystemUtil() {
    }
}

