/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import org.jphototagger.api.preferences.PreferencesHints;
import org.jphototagger.lib.swing.util.ListUtil;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.lib.util.ArrayUtil;
import org.jphototagger.lib.util.RegexUtil;

public final class Settings {
    private final Properties properties;
    public static final String BOOLEAN_FALSE_STRING = "0";
    public static final String BOOLEAN_TRUE_STRING = "1";
    private static final String DOT = ".";
    private static final String DELIMITER_NUMBER_ARRAY = ";";
    private static final String DELIMITER_ARRAY_KEYS = ".";
    public static final String TREE_PATH_SEPARATOR = "|";
    private static final String KEY_POSTFIX_VIEWPORT_VIEW_POSITION_X = ".ViewportViewPositionX";
    private static final String KEY_POSTFIX_VIEWPORT_VIEW_POSITION_Y = ".ViewportViewPositionY";
    private static final String KEY_APPENDIX_SELECTED = "-selected";
    public static final String KEY_POSTFIX_WIDTH = ".Width";
    public static final String KEY_POSTFIX_HEIGHT = ".Height";
    public static final String KEY_POSTFIX_LOCATION_X = ".LocationX";
    public static final String KEY_POSTFIX_LOCATION_Y = ".LocationY";

    public Settings(Properties properties) {
        if (properties == null) {
            throw new NullPointerException("properties == null");
        }
        this.properties = properties;
    }

    public List<String> getKeysMatching(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern == null");
        }
        return RegexUtil.getMatches(this.properties.stringPropertyNames(), pattern);
    }

    public void removeKeysWithEmptyValues() {
        Set<String> keys = this.properties.stringPropertyNames();
        for (String key : keys) {
            String value = this.properties.getProperty(key);
            if (value != null && !value.isEmpty()) continue;
            this.properties.remove(key);
        }
    }

    public void applySettings(Component component, PreferencesHints hints) {
        Field[] fields;
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        Class<?> clazz = component.getClass();
        String componentName = clazz.getName();
        for (Field field : fields = clazz.getDeclaredFields()) {
            boolean isSet;
            field.setAccessible(true);
            String fieldName = field.getName();
            String key = componentName + "." + fieldName;
            boolean bl = isSet = hints == null || !hints.isExclude(key);
            if (!isSet) continue;
            try {
                Class<?> fieldType = field.getType();
                if (fieldType.equals(JTabbedPane.class)) {
                    this.applySettings(key, (JTabbedPane)field.get(component), hints);
                    continue;
                }
                if (fieldType.equals(JSplitPane.class)) {
                    this.applySettings(key, (JSplitPane)field.get(component));
                    continue;
                }
                if (fieldType.equals(JTable.class)) {
                    this.applySettings(key, (JTable)field.get(component));
                    continue;
                }
                if (fieldType.equals(JTree.class)) {
                    this.applySettings(key, (JTree)field.get(component));
                    continue;
                }
                if (fieldType.equals(JComboBox.class)) {
                    this.applySelectedIndex(key, (JComboBox)field.get(component));
                    continue;
                }
                if (!fieldType.equals(JList.class)) continue;
                this.applySelectedIndices(key, (JList)field.get(component));
            }
            catch (Throwable t) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    public void applySettings(String key, ButtonGroup buttonGroup) {
        if (buttonGroup == null) {
            throw new NullPointerException("buttonGroup == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (this.properties.containsKey(key)) {
            String textOfSelectedButton = this.properties.getProperty(key);
            Enumeration<AbstractButton> buttons = buttonGroup.getElements();
            while (buttons.hasMoreElements()) {
                AbstractButton button = buttons.nextElement();
                if (!button.getText().equals(textOfSelectedButton)) continue;
                button.setSelected(true);
                return;
            }
        }
    }

    public void applySettings(String key, JTree tree) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        tree.clearSelection();
        int pathIndex = 0;
        String indexedKey = this.toIndexedKey(key, pathIndex);
        while (this.properties.containsKey(indexedKey)) {
            String value = this.properties.getProperty(indexedKey);
            TreePath path = TreeUtil.getTreePath(tree.getModel(), this.removeSelToken(value), TREE_PATH_SEPARATOR);
            if (path != null) {
                TreeUtil.expandPath(tree, path);
                tree.scrollPathToVisible(path);
                if (this.isSelected(value)) {
                    tree.addSelectionPath(path);
                }
            }
            indexedKey = this.toIndexedKey(key, ++pathIndex);
        }
    }

    private String toIndexedKey(String key, int index) {
        return key + "." + Integer.toString(index);
    }

    private String removeSelToken(String path) {
        int sepIndex = path.lastIndexOf(TREE_PATH_SEPARATOR);
        int length = path.length();
        return sepIndex >= 0 && sepIndex < length - 1 ? path.substring(0, sepIndex) : path;
    }

    private boolean isSelected(String path) {
        int sepIndex = path.lastIndexOf(TREE_PATH_SEPARATOR);
        int length = path.length();
        if (sepIndex >= 0 && sepIndex < length - 1) {
            return path.substring(sepIndex + 1).equals(BOOLEAN_TRUE_STRING);
        }
        return false;
    }

    public void applySettings(String key, JSplitPane splitPane) {
        if (splitPane == null) {
            throw new NullPointerException("splitPane == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (this.properties.containsKey(key)) {
            try {
                int location = Integer.parseInt(this.properties.getProperty(key));
                splitPane.setDividerLocation(location);
            }
            catch (Throwable t) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    public void applySettings(String key, JScrollPane scrollPane) {
        if (scrollPane == null) {
            throw new NullPointerException("scrollPane == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        String keyX = key + KEY_POSTFIX_VIEWPORT_VIEW_POSITION_X;
        String keyY = key + KEY_POSTFIX_VIEWPORT_VIEW_POSITION_Y;
        if (this.properties.containsKey(keyX) && this.properties.containsKey(keyY)) {
            try {
                int x = Integer.parseInt(this.properties.getProperty(keyX));
                int y = Integer.parseInt(this.properties.getProperty(keyY));
                scrollPane.getViewport().setViewPosition(new Point(x, y));
            }
            catch (Throwable t) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    public void applySettings(String key, JTable table) {
        if (table == null) {
            throw new NullPointerException("table == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        TableModel model = table.getModel();
        if (this.properties.containsKey(key)) {
            TableColumnModel colModel = table.getColumnModel();
            List<Integer> storedWidths = this.getIntegerCollection(key);
            int tableColumnCount = model.getColumnCount();
            int storedColumnCount = storedWidths.size();
            for (int index = 0; index < tableColumnCount && index < storedColumnCount; ++index) {
                colModel.getColumn(index).setPreferredWidth(storedWidths.get(index));
            }
        }
    }

    public void applySettings(String key, JSpinner spinner) {
        if (spinner == null) {
            throw new NullPointerException("spinner == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (this.properties.containsKey(key)) {
            String value = this.properties.getProperty(key);
            try {
                spinner.setValue(Integer.parseInt(value));
            }
            catch (Throwable t) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    public void applySettings(String key, JTabbedPane pane, PreferencesHints hints) {
        int index;
        if (pane == null) {
            throw new NullPointerException("pane == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (this.properties.containsKey(key)) {
            String value = this.properties.getProperty(key);
            try {
                index = Integer.parseInt(value);
                if (index < pane.getTabCount()) {
                    pane.setSelectedIndex(index);
                }
            }
            catch (Throwable t) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        if (hints != null && hints.isOption(PreferencesHints.Option.SET_TABBED_PANE_CONTENT)) {
            int componentCount = pane.getComponentCount();
            for (index = 0; index < componentCount; ++index) {
                this.applySettings(pane.getComponentAt(index), hints);
            }
        }
    }

    public void applySelectedIndex(String key, JComboBox<?> comboBox) {
        if (comboBox == null) {
            throw new NullPointerException("comboBox == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        String index = this.properties.getProperty(key + KEY_APPENDIX_SELECTED);
        if (index != null) {
            try {
                int ind = Integer.parseInt(index);
                if (ind < comboBox.getItemCount()) {
                    comboBox.setSelectedIndex(ind);
                }
            }
            catch (Throwable t) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    public void applySettings(String key, JToggleButton button) {
        if (button == null) {
            throw new NullPointerException("button == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        String status = this.properties.getProperty(key);
        if (status != null) {
            button.setSelected(status.equals(BOOLEAN_TRUE_STRING));
        }
    }

    public void applySelectedIndices(String key, JList<?> list) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        list.clearSelection();
        List<Integer> selIndices = this.getIntegerCollection(key + KEY_APPENDIX_SELECTED);
        if (selIndices.isEmpty()) {
            return;
        }
        List<Integer> existingIndices = ListUtil.getExistingIndicesOf(ArrayUtil.toIntArray(selIndices), list);
        if (!existingIndices.isEmpty()) {
            try {
                if (list.getSelectionMode() == 0) {
                    list.setSelectedIndex(existingIndices.get(0));
                } else {
                    Collections.sort(existingIndices);
                    for (int index : existingIndices) {
                        list.addSelectionInterval(index, index);
                    }
                }
                list.ensureIndexIsVisible(existingIndices.get(0));
            }
            catch (Throwable t) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    public String getString(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (this.properties.containsKey(key)) {
            return this.properties.getProperty(key);
        }
        return "";
    }

    public void setIntegerCollection(String key, Collection<? extends Integer> integers) {
        if (integers == null) {
            throw new NullPointerException("array == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        StringBuilder sb = new StringBuilder();
        for (Integer n : integers) {
            sb.append(n.toString());
            sb.append(DELIMITER_NUMBER_ARRAY);
        }
        this.properties.setProperty(key, sb.toString());
    }

    public void setStringCollection(String key, Collection<? extends String> strings) {
        if (strings == null) {
            throw new NullPointerException("strings == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.deleteKeysMatching(this.getArrayKeyMatchPattern(key));
        int index = 0;
        for (String string : strings) {
            this.properties.setProperty(key + "." + Integer.toString(index), string);
            ++index;
        }
    }

    public void deleteKeysMatching(String pattern) {
        if (pattern == null) {
            throw new NullPointerException("pattern == null");
        }
        for (String key : this.getKeysMatching(pattern)) {
            this.properties.remove(key);
        }
    }

    public List<Integer> getIntegerCollection(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        ArrayList<Integer> integers = new ArrayList<Integer>();
        if (this.properties.containsKey(key)) {
            StringTokenizer tokenizer = new StringTokenizer(this.properties.getProperty(key), DELIMITER_NUMBER_ARRAY);
            while (tokenizer.hasMoreTokens()) {
                try {
                    integers.add(new Integer(tokenizer.nextToken()));
                }
                catch (Throwable t) {
                    Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
                }
            }
        }
        return integers;
    }

    public List<String> getStringCollection(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        ArrayList<String> strings = new ArrayList<String>();
        List<String> keys = this.getKeysMatching(this.getArrayKeyMatchPattern(key));
        Collections.sort(keys);
        for (String stringKey : keys) {
            strings.add(this.properties.getProperty(stringKey));
        }
        return strings;
    }

    public void removeStringCollection(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        for (String k : this.getKeysMatching(this.getArrayKeyMatchPattern(key))) {
            this.properties.remove(k);
        }
    }

    public void set(Component component, PreferencesHints hints) {
        Field[] fields;
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        Class<?> c = component.getClass();
        String componentName = c.getName();
        for (Field field : fields = c.getDeclaredFields()) {
            boolean isSet;
            field.setAccessible(true);
            String fieldName = field.getName();
            String key = componentName + "." + fieldName;
            boolean bl = isSet = hints == null || !hints.isExclude(key);
            if (!isSet) continue;
            try {
                Class<?> fieldType = field.getType();
                if (fieldType.equals(JComboBox.class)) {
                    this.setSelectedIndex(key, (JComboBox)field.get(component));
                    continue;
                }
                if (fieldType.equals(JList.class)) {
                    this.setSelectedIndices(key, (JList)field.get(component));
                    continue;
                }
                if (fieldType.equals(JTabbedPane.class)) {
                    this.set(key, (JTabbedPane)field.get(component), hints);
                    continue;
                }
                if (fieldType.equals(JTable.class)) {
                    this.set(key, (JTable)field.get(component));
                    continue;
                }
                if (fieldType.equals(JSplitPane.class)) {
                    this.set(key, (JSplitPane)field.get(component));
                    continue;
                }
                if (!fieldType.equals(JTree.class)) continue;
                this.set(key, (JTree)field.get(component));
            }
            catch (Throwable t) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    public void set(String key, ButtonGroup buttonGroup) {
        if (buttonGroup == null) {
            throw new NullPointerException("buttonGroup == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        String textOfSelectedButton = null;
        Enumeration<AbstractButton> buttons = buttonGroup.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton button = buttons.nextElement();
            if (!button.isSelected()) continue;
            textOfSelectedButton = button.getText();
        }
        if (textOfSelectedButton != null && !textOfSelectedButton.isEmpty()) {
            this.properties.setProperty(key, textOfSelectedButton);
        }
    }

    public void set(String key, JSpinner spinner) {
        if (spinner == null) {
            throw new NullPointerException("spinner == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.properties.setProperty(key, spinner.getValue().toString());
    }

    public void set(String key, JTabbedPane pane, PreferencesHints hints) {
        if (pane == null) {
            throw new NullPointerException("pane == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        try {
            int index = pane.getSelectedIndex();
            this.properties.setProperty(key, Integer.toString(index));
            if (hints != null && hints.isOption(PreferencesHints.Option.SET_TABBED_PANE_CONTENT)) {
                int componentCount = pane.getComponentCount();
                for (int i = 0; i < componentCount; ++i) {
                    this.set(pane.getComponentAt(i), hints);
                }
            }
        }
        catch (Throwable t) {
            Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public void setSelectedIndex(String key, JComboBox<?> comboBox) {
        if (comboBox == null) {
            throw new NullPointerException("comboBox == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.properties.setProperty(key + KEY_APPENDIX_SELECTED, Integer.toString(comboBox.getSelectedIndex()));
    }

    public void set(String key, JToggleButton button) {
        if (button == null) {
            throw new NullPointerException("button == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        String status = button.isSelected() ? BOOLEAN_TRUE_STRING : BOOLEAN_FALSE_STRING;
        this.properties.setProperty(key, status);
    }

    public void setSelectedIndices(String key, JList<?> list) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        int[] selIndices = list.getSelectedIndices();
        String keySelIndices = key + KEY_APPENDIX_SELECTED;
        if (selIndices.length == 0) {
            this.properties.remove(keySelIndices);
        } else {
            this.setIntegerCollection(keySelIndices, ArrayUtil.toList(selIndices));
        }
    }

    public void set(String key, String string) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.properties.setProperty(key, string);
    }

    public void removeKey(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.properties.remove(key);
    }

    public void set(String key, JTable table) {
        if (table == null) {
            throw new NullPointerException("table == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        TableModel model = table.getModel();
        ArrayList<Integer> colWidths = new ArrayList<Integer>();
        TableColumnModel colModel = table.getColumnModel();
        int tableColumnCount = model.getColumnCount();
        for (int index = 0; index < tableColumnCount; ++index) {
            colWidths.add(colModel.getColumn(index).getWidth());
        }
        this.setIntegerCollection(key, colWidths);
    }

    public void set(String key, JSplitPane splitPane) {
        if (splitPane == null) {
            throw new NullPointerException("splitPane == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        int dividerLocation = splitPane.getDividerLocation();
        this.properties.setProperty(key, Integer.toString(dividerLocation));
    }

    public void set(String key, JScrollPane scrollPane) {
        if (scrollPane == null) {
            throw new NullPointerException("scrollPane == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        Integer x = scrollPane.getViewport().getViewPosition().x;
        Integer y = scrollPane.getViewport().getViewPosition().y;
        this.properties.setProperty(key + KEY_POSTFIX_VIEWPORT_VIEW_POSITION_X, x.toString());
        this.properties.setProperty(key + KEY_POSTFIX_VIEWPORT_VIEW_POSITION_Y, y.toString());
    }

    public void set(String key, JTree tree) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        int rowCount = tree.getRowCount();
        int pathIndex = 0;
        this.deleteKeysMatching(key + "\\.[0-9]+");
        for (int row = 0; row < rowCount; ++row) {
            if (tree.isExpanded(row)) {
                this.setTreePath(this.toIndexedKey(key, pathIndex), tree.getPathForRow(row).getPath(), tree.isRowSelected(row));
                ++pathIndex;
                continue;
            }
            if (!tree.isRowSelected(row)) continue;
            this.setTreePath(this.toIndexedKey(key, pathIndex), tree.getPathForRow(row).getPath(), true);
            ++pathIndex;
        }
    }

    private void setTreePath(String key, Object[] path, boolean selected) {
        StringBuilder sb = new StringBuilder();
        for (Object path1 : path) {
            sb.append(path1.toString());
            sb.append(TREE_PATH_SEPARATOR);
        }
        sb.append(selected ? BOOLEAN_TRUE_STRING : BOOLEAN_FALSE_STRING);
        this.properties.setProperty(key, sb.toString());
    }

    public int getInt(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        int result = Integer.MIN_VALUE;
        if (this.properties.containsKey(key)) {
            try {
                result = Integer.parseInt(this.properties.getProperty(key));
            }
            catch (Throwable t) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return result;
    }

    public void set(String key, int value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.properties.setProperty(key, Integer.toString(value));
    }

    public boolean getBoolean(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        return this.getInt(key) == 1;
    }

    public void set(String key, boolean b) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.set(key, b ? 1 : 0);
    }

    public void applySizeAndLocation(Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        this.applySize(component);
        this.applyLocation(component);
    }

    public void applySize(Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        this.applySize(component.getClass().getName(), component);
    }

    public boolean containsKey(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        return this.properties.containsKey(key);
    }

    public void applySize(String key, Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        String keyWidth = Settings.getKeyWidth(key);
        String keyHeight = Settings.getKeyHeight(key);
        if (this.properties.containsKey(keyWidth) && this.properties.containsKey(keyHeight)) {
            try {
                int width = Integer.parseInt(this.properties.getProperty(keyWidth));
                int height = Integer.parseInt(this.properties.getProperty(keyHeight));
                Dimension preferredSize = component.getPreferredSize();
                if (width < preferredSize.width) {
                    width = preferredSize.width;
                }
                if (height < preferredSize.height) {
                    height = preferredSize.height;
                }
                Dimension dimension = new Dimension(width, height);
                component.setPreferredSize(dimension);
                component.setSize(dimension);
            }
            catch (Throwable t) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    public boolean containsSizeKey(String key) {
        String keyWidth = Settings.getKeyWidth(key);
        String keyHeight = Settings.getKeyHeight(key);
        return this.properties.containsKey(keyWidth) && this.properties.containsKey(keyHeight);
    }

    public void applyLocation(Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        this.applyLocation(component.getClass().getName(), component);
    }

    public boolean applyLocation(String key, Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        String keyLocationX = Settings.getKeyLocationX(key);
        String keyLocationY = Settings.getKeyLocationY(key);
        if (this.properties.containsKey(keyLocationX) && this.properties.containsKey(keyLocationY)) {
            try {
                int locationX = Integer.parseInt(this.properties.getProperty(keyLocationX));
                int locationY = Integer.parseInt(this.properties.getProperty(keyLocationY));
                component.setLocation(new Point(locationX, locationY));
                return true;
            }
            catch (Throwable t) {
                Logger.getLogger(Settings.class.getName()).log(Level.SEVERE, null, t);
            }
        }
        return false;
    }

    public boolean containsLocationKey(String key) {
        String keyLocationX = Settings.getKeyLocationX(key);
        String keyLocationY = Settings.getKeyLocationY(key);
        return this.properties.containsKey(keyLocationX) && this.properties.containsKey(keyLocationY);
    }

    public void setSizeAndLocation(Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        this.setSize(component);
        this.setLocation(component);
    }

    public void setSize(Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        this.setSize(component.getClass().getName(), component);
    }

    public void setSize(String key, Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        Dimension size = component.getSize();
        this.properties.setProperty(Settings.getKeyWidth(key), Integer.toString(size.width));
        this.properties.setProperty(Settings.getKeyHeight(key), Integer.toString(size.height));
    }

    public void setLocation(Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        this.setLocation(component.getClass().getName(), component);
    }

    public void setLocation(String key, Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        Point location = component.getLocation();
        this.properties.setProperty(Settings.getKeyLocationX(key), Integer.toString(location.x));
        this.properties.setProperty(Settings.getKeyLocationY(key), Integer.toString(location.y));
    }

    private static String getKeyHeight(String key) {
        return key + KEY_POSTFIX_HEIGHT;
    }

    private static String getKeyWidth(String key) {
        return key + KEY_POSTFIX_WIDTH;
    }

    private static String getKeyLocationX(String key) {
        return key + KEY_POSTFIX_LOCATION_X;
    }

    private static String getKeyLocationY(String key) {
        return key + KEY_POSTFIX_LOCATION_Y;
    }

    private String getArrayKeyMatchPattern(String key) {
        return "^" + Pattern.quote(key + ".") + "[0-9]+$";
    }

    public Set<String> keys() {
        HashSet<String> keys = new HashSet<String>();
        for (Object key : this.properties.keySet()) {
            if (key == null) continue;
            keys.add(key.toString());
        }
        return keys;
    }
}

