/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jphototagger.lib.io.FileUtil;

public final class PropertiesFile {
    private final String filename;
    private final String domainName;
    private final Properties properties;
    private final String projectName;
    private final String directoryName;

    public PropertiesFile(String domainName, String projectName, String filename, Properties properties) {
        if (domainName == null) {
            throw new NullPointerException("domainName == null");
        }
        if (projectName == null) {
            throw new NullPointerException("appName == null");
        }
        if (filename == null) {
            throw new NullPointerException("filename == null");
        }
        if (properties == null) {
            throw new NullPointerException("properties == null");
        }
        this.domainName = domainName;
        this.projectName = projectName;
        this.filename = filename;
        this.properties = properties;
        this.directoryName = this.initGetDirectoryName();
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile() throws IOException {
        FileUtil.ensureDirectoryExists(new File(this.directoryName));
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.getPropertyFilePathName());
            this.properties.store(out, "--- " + this.projectName + " persistent settings ---");
        }
        catch (Throwable t) {
            Logger.getLogger(PropertiesFile.class.getName()).log(Level.SEVERE, null, t);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(PropertiesFile.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromFile() {
        String propertyFilename = this.getPropertyFilePathName();
        if (FileUtil.existsFile(new File(propertyFilename))) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(propertyFilename);
                this.properties.load(in);
            }
            catch (Throwable t) {
                Logger.getLogger(PropertiesFile.class.getName()).log(Level.SEVERE, null, t);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(PropertiesFile.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }
    }

    private String getPropertyFilePathName() {
        return this.directoryName + File.separator + this.filename;
    }

    private String initGetDirectoryName() {
        String homeDir = System.getProperty("user.home");
        return homeDir + File.separator + "." + this.domainName + File.separator + this.projectName;
    }
}

