/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import org.jphototagger.api.concurrent.Cancelable;
import org.jphototagger.api.progress.ProgressEvent;
import org.jphototagger.api.progress.ProgressHandle;
import org.jphototagger.api.progress.ProgressHandleFactory;
import org.jphototagger.api.progress.ProgressListener;
import org.openide.util.Lookup;

public final class ProgressBarUpdater
implements ProgressListener {
    private final String progressBarString;
    private final Object source;
    private ProgressHandle progressHandle;

    public ProgressBarUpdater(Object source, String progressBarString) {
        if (source == null) {
            throw new NullPointerException("source == null");
        }
        this.source = source;
        this.progressBarString = progressBarString;
    }

    private void modifyProgressEvent(ProgressEvent evt) {
        evt.setSource(this.source);
        evt.setStringPainted(this.progressBarString != null);
        evt.setStringToPaint(this.progressBarString);
    }

    public void progressStarted(ProgressEvent evt) {
        this.modifyProgressEvent(evt);
        ProgressHandleFactory phFactory = (ProgressHandleFactory)Lookup.getDefault().lookup(ProgressHandleFactory.class);
        this.progressHandle = this.source instanceof Cancelable ? phFactory.createProgressHandle((Cancelable)this.source) : phFactory.createProgressHandle();
        this.progressHandle.progressStarted(evt);
    }

    public void progressPerformed(ProgressEvent evt) {
        this.modifyProgressEvent(evt);
        this.progressHandle.progressPerformed(evt);
    }

    public synchronized void progressEnded(ProgressEvent evt) {
        this.progressHandle.progressEnded();
    }
}

