/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.util.logging.Level;
import java.util.logging.Logger;

public class MutualExcludedResource<T> {
    private T resource = null;
    private boolean locked = false;
    private Object owner = null;
    private static final Logger logger = Logger.getLogger(MutualExcludedResource.class.getName());

    public synchronized boolean isAvailable() {
        return !this.isLocked() && this.resource != null;
    }

    public synchronized T getResource(Object owner) {
        if (owner == null) {
            throw new NullPointerException("owner == null");
        }
        if (this.isAvailable()) {
            this.setLocked(true);
            this.setOwner(owner);
            this.logGained(owner);
            return this.resource;
        }
        return null;
    }

    private void logGained(Object owner) {
        String resourceName = this.resource.getClass().getSimpleName();
        String ownerName = owner.getClass().getSimpleName();
        int ownerId = owner.hashCode();
        String ownerString = owner.toString();
        logger.log(Level.FINEST, "Resource {0} give to {1} [{2}, {3}]", new Object[]{resourceName, ownerName, ownerId, ownerString});
    }

    public synchronized boolean releaseResource(Object owner) {
        if (owner == null) {
            throw new NullPointerException("o == null");
        }
        if (this.isLocked() && owner != null && owner == this.getOwner()) {
            this.owner = null;
            this.setLocked(false);
            this.logReleased(owner);
            return true;
        }
        return false;
    }

    private void logReleased(Object owner) {
        String resourceName = this.resource.getClass().getSimpleName();
        String ownerName = owner.getClass().getSimpleName();
        int ownerId = owner.hashCode();
        String ownerString = owner.toString();
        logger.log(Level.FINEST, "Resource {0} released from {1} [{2}, {3}]]", new Object[]{resourceName, ownerName, ownerId, ownerString});
    }

    protected synchronized void setResource(T resource) {
        if (resource == null) {
            throw new NullPointerException("resource == null");
        }
        this.resource = resource;
    }

    private synchronized void setLocked(boolean lock) {
        this.locked = lock;
    }

    private synchronized boolean isLocked() {
        return this.locked;
    }

    private synchronized void setOwner(Object owner) {
        this.owner = owner;
    }

    public synchronized Object getOwner() {
        return this.owner;
    }

    protected MutualExcludedResource() {
    }
}

