/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;

public final class HtmlUtil {
    private static final Map<Character, String> ESCAPED_HTML_CHAR_OF = new HashMap<Character, String>();

    public static String escapeHTML(String string) {
        StringBuilder sb = new StringBuilder();
        for (char character : string.toCharArray()) {
            String escapedCharacter = ESCAPED_HTML_CHAR_OF.get(Character.valueOf(character));
            sb.append(escapedCharacter == null ? Character.valueOf(character) : escapedCharacter);
        }
        return sb.toString();
    }

    public static String html2PlainText(String htmlText) {
        if (htmlText == null) {
            throw new NullPointerException("htmlText == null");
        }
        ParserCallback parser = new ParserCallback();
        try {
            parser.parse(new StringReader(htmlText));
        }
        catch (IOException ex) {
            Logger.getLogger(ParserCallback.class.getName()).log(Level.SEVERE, null, ex);
        }
        return parser.getText();
    }

    private HtmlUtil() {
    }

    static {
        ESCAPED_HTML_CHAR_OF.put(Character.valueOf('<'), "&lt;");
        ESCAPED_HTML_CHAR_OF.put(Character.valueOf('>'), "&gt;");
        ESCAPED_HTML_CHAR_OF.put(Character.valueOf('\"'), "&quot;");
        ESCAPED_HTML_CHAR_OF.put(Character.valueOf('&'), "&amp;");
    }

    private static final class ParserCallback
    extends HTMLEditorKit.ParserCallback {
        private StringBuilder sb;

        private ParserCallback() {
        }

        private void parse(Reader reader) throws IOException {
            this.sb = new StringBuilder();
            ParserDelegator delegator = new ParserDelegator();
            delegator.parse(reader, this, true);
        }

        @Override
        public void handleText(char[] text, int pos) {
            this.sb.append(text);
        }

        private String getText() {
            return this.sb.toString();
        }
    }
}

