/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Content<T> {
    private T content;
    private final Set<Listener<T>> listeners = new CopyOnWriteArraySet<Listener<T>>();

    public void addListener(Listener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.listeners.add(listener);
    }

    public synchronized T getContent() {
        return this.content;
    }

    public synchronized boolean isEmpty() {
        return this.content == null;
    }

    public void removeListener(Listener<T> listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.listeners.remove(listener);
    }

    private void notifyListeners(Type type) {
        for (Listener<T> listener : this.listeners) {
            if (type.equals((Object)Type.ADDED)) {
                listener.contentAdded(this.content);
                continue;
            }
            if (!type.equals((Object)Type.REMOVED)) continue;
            listener.contentRemoved();
        }
    }

    public synchronized void set(T content) {
        if (content == null) {
            throw new NullPointerException("content == null");
        }
        Logger.getLogger(this.getClass().getName()).log(Level.FINEST, content.toString());
        this.content = content;
        this.notifyListeners(Type.ADDED);
    }

    public synchronized void remove() {
        this.content = null;
        Logger.getLogger(this.getClass().getName()).log(Level.FINEST, "Empty");
        this.notifyListeners(Type.REMOVED);
    }

    public static interface Listener<T> {
        public void contentAdded(T var1);

        public void contentRemoved();
    }

    private static enum Type {
        ADDED,
        REMOVED;

    }
}

