/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public final class CommandLineParser {
    private final Set<Option> options = new HashSet<Option>();
    private final String[] args;
    private final String optionsDelimiter;
    private final String optionsValuesDelimiter;

    public CommandLineParser(String[] args, String optionsDelimiter, String optionsValuesDelimiter) {
        if (args == null) {
            throw new NullPointerException("args == null");
        }
        if (optionsDelimiter == null) {
            throw new NullPointerException("optionsDelimiter == null");
        }
        if (optionsValuesDelimiter == null) {
            throw new NullPointerException("optionsValuesDelimiter == null");
        }
        this.args = Arrays.copyOf(args, args.length);
        this.optionsDelimiter = optionsDelimiter;
        this.optionsValuesDelimiter = optionsValuesDelimiter;
        this.parseOptions();
    }

    public boolean hasOption(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        for (Option option : this.options) {
            if (!option.name.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Option getOption(String name) {
        if (name == null) {
            throw new NullPointerException("name == null");
        }
        for (Option option : this.options) {
            if (!option.name.equalsIgnoreCase(name)) continue;
            return option;
        }
        return null;
    }

    private void parseOptions() {
        int length = this.args.length;
        Option option = null;
        for (int i = 0; i < length; ++i) {
            String arg = this.args[i].trim();
            boolean isOption = this.isOption(arg);
            if (isOption) {
                option = new Option(this.ensureOptionName(arg, i));
                this.delimitValuesFromName(arg, option);
                this.options.add(option);
                continue;
            }
            for (int j = i + 1; j < length && !isOption; ++j) {
                arg = this.args[j].trim();
                isOption = this.isOption(arg);
                if (isOption) continue;
                if (arg.startsWith(this.optionsValuesDelimiter)) {
                    arg = arg.substring(1);
                }
                option.addValue(arg.trim());
                i = j;
            }
        }
    }

    private boolean isOption(String arg) {
        return arg.startsWith(this.optionsDelimiter);
    }

    private String ensureOptionName(String arg, int argIndex) {
        String optionName;
        String string = optionName = arg.length() > 1 ? arg.substring(1) : null;
        if (optionName == null || optionName.substring(0, 1).equals(this.optionsValuesDelimiter)) {
            throw new IllegalArgumentException("Invalid option for argument " + argIndex + ", " + arg);
        }
        StringTokenizer st = new StringTokenizer(optionName, this.optionsValuesDelimiter);
        if (st.countTokens() < 1) {
            throw new IllegalArgumentException("Invalid option for argument " + argIndex + ", " + arg);
        }
        return st.nextToken().trim();
    }

    private void delimitValuesFromName(String arg, Option option) {
        StringTokenizer st = new StringTokenizer(arg, this.optionsValuesDelimiter);
        if (st.countTokens() < 2) {
            return;
        }
        st.nextToken();
        while (st.hasMoreTokens()) {
            option.addValue(st.nextToken().trim());
        }
    }

    public static class Option {
        private final List<String> values = new ArrayList<String>();
        private final String name;

        public Option(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getValues() {
            return this.values;
        }

        public void addValue(String param) {
            this.values.add(param);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Option other = (Option)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return this.values == other.values || this.values != null && this.values.equals(other.values);
        }

        public int hashCode() {
            int hash = 5;
            hash = 89 * hash + (this.name != null ? this.name.hashCode() : 0);
            hash = 89 * hash + (this.values != null ? this.values.hashCode() : 0);
            return hash;
        }

        public String toString() {
            return this.name;
        }
    }
}

