/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public final class CollectionUtil {
    private static final String EMPTY_STRING = "";

    public static <T> void binaryInsert(LinkedList<? super T> list, T element) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        if (element == null) {
            throw new NullPointerException("element == null");
        }
        boolean isComparable = element instanceof Comparable;
        if (!isComparable) {
            throw new IllegalArgumentException("Not a comparable: " + element);
        }
        int size = list.size();
        int low = 0;
        int high = size - 1;
        int index = size;
        int cmp = 1;
        while (low <= high && cmp > 0) {
            int mid = low + high >>> 1;
            Comparable midVal = (Comparable)list.get(mid);
            cmp = midVal.compareTo(element);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp <= 0) continue;
            high = mid - 1;
        }
        for (int i = low; i >= 0 && i < size && index == size; ++i) {
            Comparable elt = (Comparable)list.get(i);
            if (elt.compareTo(element) < 0) continue;
            index = i;
        }
        list.add(index, element);
    }

    public static List<String> toStringList(Collection<?> coll) {
        if (coll == null) {
            throw new NullPointerException("coll == null");
        }
        ArrayList<String> list = new ArrayList<String>(coll.size());
        for (Object o : coll) {
            if (o == null) {
                list.add(null);
                continue;
            }
            list.add(o.toString());
        }
        return list;
    }

    public static List<String> stringTokenToList(String string, String delimiter) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        StringTokenizer tokenizer = new StringTokenizer(string, delimiter);
        ArrayList<String> list = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list;
    }

    public static List<Integer> integerTokenToList(String string, String delimiter) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        ArrayList<Integer> integerList = new ArrayList<Integer>();
        StringTokenizer tokenizer = new StringTokenizer(string, delimiter);
        while (tokenizer.hasMoreTokens()) {
            integerList.add(Integer.parseInt(tokenizer.nextToken()));
        }
        return integerList;
    }

    public static boolean isValidIndex(List<?> list, int index) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        return index >= 0 && index < list.size();
    }

    public static <T> void addNotContainedElements(Collection<? extends T> src, Collection<? super T> target) {
        if (src == target) {
            return;
        }
        for (T t : src) {
            if (target.contains(t)) continue;
            target.add(t);
        }
    }

    public static String toTokenString(Collection<? extends Object> collection, String delimiter, String delimiterReplacement) {
        if (collection == null) {
            throw new NullPointerException("collection == null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        if (delimiterReplacement == null) {
            throw new NullPointerException("delimiterReplacement == null");
        }
        StringBuilder tokenString = new StringBuilder();
        int index = 0;
        for (Object object : collection) {
            tokenString.append(index == 0 ? EMPTY_STRING : delimiter);
            tokenString.append(object.toString().replace(delimiter, delimiterReplacement));
            ++index;
        }
        return tokenString.toString();
    }

    public static <T> T getFirstElement(Collection<? extends T> collection) {
        return collection.size() > 0 ? (T)collection.iterator().next() : null;
    }

    public static boolean containsStringIgnoreCase(Collection<? extends String> strings, String string) {
        if (strings == null) {
            throw new NullPointerException("strings == null");
        }
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        for (String string2 : strings) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    private CollectionUtil() {
    }
}

