/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.List;
import org.jphototagger.lib.datatransfer.TransferUtil;
import org.jphototagger.lib.datatransfer.TransferableFileCollection;

public final class ClipboardUtil {
    private static final DataFlavor STRING_FLAVOR = DataFlavor.stringFlavor;
    private static final DataFlavor FILE_LIST_FLAVOR = DataFlavor.javaFileListFlavor;
    private static final DataFlavor URI_LIST_FLAVOR = TransferUtil.getUriListFlavor();

    public static void copyToSystemClipboard(List<File> files, ClipboardOwner owner) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        ClipboardUtil.copyToClipboard(files, Toolkit.getDefaultToolkit().getSystemClipboard(), owner);
    }

    public static void copyToClipboard(List<File> files, Clipboard clipboard, ClipboardOwner owner) {
        if (files == null) {
            throw new NullPointerException("files == null");
        }
        if (clipboard == null) {
            throw new NullPointerException("clipboard == null");
        }
        clipboard.setContents(new TransferableFileCollection(files), owner);
    }

    public static void copyToSystemClipboard(String text, ClipboardOwner owner) {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(text), owner);
    }

    public static List<File> getFilesFromSystemClipboard(TransferUtil.FilenameDelimiter delimiter) {
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        return ClipboardUtil.getFilesFromClipboard(Toolkit.getDefaultToolkit().getSystemClipboard(), delimiter);
    }

    public static List<File> getFilesFromClipboard(Clipboard clipboard, TransferUtil.FilenameDelimiter delimiter) {
        if (clipboard == null) {
            throw new NullPointerException("files == null");
        }
        if (delimiter == null) {
            throw new NullPointerException("delimiter == null");
        }
        List<File> files = null;
        DataFlavor[] flavors = clipboard.getAvailableDataFlavors();
        Transferable transferable = clipboard.getContents(ClipboardUtil.class);
        if (TransferUtil.isDataFlavorSupported(flavors, FILE_LIST_FLAVOR)) {
            return TransferUtil.getFilesFromJavaFileList(transferable);
        }
        if (TransferUtil.isDataFlavorSupported(flavors, URI_LIST_FLAVOR)) {
            return TransferUtil.getFilesFromUriList(transferable);
        }
        if (TransferUtil.isDataFlavorSupported(flavors, STRING_FLAVOR)) {
            return TransferUtil.getFilesFromTokenString(transferable, delimiter);
        }
        return files;
    }

    private ClipboardUtil() {
    }
}

