/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.io.PrintStream;
import java.nio.ByteBuffer;

public final class ByteUtil {
    public static int toInt(byte b) {
        int i = b;
        return i &= 0xFF;
    }

    public static boolean[] getBits(byte b) {
        boolean[] bits = new boolean[8];
        for (int i = 0; i < bits.length; ++i) {
            bits[i] = (b & 1 << i) != 0;
        }
        return bits;
    }

    public static void dumpBits(byte[] b, PrintStream out) {
        if (b == null) {
            throw new NullPointerException("b == null");
        }
        if (out == null) {
            throw new NullPointerException("out == null");
        }
        out.println();
        for (int i = 0; i < b.length; ++i) {
            boolean[] bits = ByteUtil.getBits(b[i]);
            for (int j = bits.length - 1; j >= 0; --j) {
                out.print(bits[j] ? "1" : "0");
            }
            out.print(" ");
        }
    }

    public static int compareTo(byte[] a1, byte[] a2) {
        if (a1 == null) {
            throw new NullPointerException("a1 == null");
        }
        if (a2 == null) {
            throw new NullPointerException("a2 == null");
        }
        ByteBuffer buf1 = ByteBuffer.wrap(a1);
        ByteBuffer buf2 = ByteBuffer.wrap(a2);
        return buf1.compareTo(buf2);
    }

    public static boolean equals(byte[] a1, byte[] a2) {
        if (a1 == null && a2 == null) {
            return true;
        }
        if (a1 == null || a2 == null) {
            return false;
        }
        if (a1.length != a2.length) {
            return false;
        }
        for (int i = 0; i < a1.length; ++i) {
            byte b1 = a1[i];
            byte b2 = a2[i];
            if (b1 == b2) continue;
            return false;
        }
        return true;
    }

    private ByteUtil() {
    }
}

