/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Bundle {
    public static String getString(Class<?> classWithinSamePackageAsBundle, String key, Object ... params) {
        if (classWithinSamePackageAsBundle == null) {
            throw new NullPointerException("classWithinSamePackageAsBundle == null");
        }
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        String packagePath = classWithinSamePackageAsBundle.getPackage().getName();
        String bundlePath = packagePath + ".Bundle";
        ResourceBundle bundle = ResourceBundle.getBundle(bundlePath);
        return Bundle.getFormattedString(bundle, key, params);
    }

    private static String getFormattedString(ResourceBundle bundle, String key, Object ... params) {
        try {
            String s = bundle.getString(key);
            return params == null || params.length == 0 ? s : MessageFormat.format(s, params);
        }
        catch (Throwable t) {
            Logger.getLogger(Bundle.class.getName()).log(Level.SEVERE, null, t);
            return "?" + key + "?";
        }
    }

    private Bundle() {
    }
}

