/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ArrayUtil {
    public static String[] toStringArray(Object[] objectArray) {
        if (objectArray == null) {
            throw new NullPointerException("array == null");
        }
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) {
                throw new IllegalArgumentException("Element at index " + i + " is null");
            }
            Object object = objectArray[i];
            stringArray[i] = object.toString();
        }
        return stringArray;
    }

    public static <T> int[] toIntArray(Collection<? extends Integer> c) {
        if (c == null) {
            throw new NullPointerException("c == null");
        }
        int[] array = new int[c.size()];
        int index = 0;
        Iterator<? extends Integer> i$ = c.iterator();
        while (i$.hasNext()) {
            int el;
            array[index] = el = i$.next().intValue();
            ++index;
        }
        return array;
    }

    public static List<Integer> toList(int[] array) {
        if (array == null) {
            throw new NullPointerException("array == null");
        }
        ArrayList<Integer> list = new ArrayList<Integer>(array.length);
        for (int el : array) {
            list.add(el);
        }
        return list;
    }

    public static boolean byteArraysEquals(byte[] left, byte[] right) {
        if (left == null) {
            throw new NullPointerException("Left byte array is null!");
        }
        if (right == null) {
            throw new NullPointerException("Right byte array is null!");
        }
        if (left.length != right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            if (left[i] == right[i]) continue;
            return false;
        }
        return true;
    }

    private ArrayUtil() {
    }
}

