/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.thirdparty;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DateFormatSymbols;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jphototagger.lib.swing.IconUtil;
import org.jphototagger.lib.util.Bundle;

public final class DateChooserDialog
extends JComponent {
    private static final long serialVersionUID = 1L;
    private final String[] dayStr;
    private final String[] monthStr;
    private final JButton previousButton;
    private final JButton nextButton;
    private final JLabel[] dayOfWeekLabels = new JLabel[7];
    private final JLabel[] dayOfMonthLabels = new JLabel[42];
    private final JLabel monthYearLabel;
    private final Locale locale;
    private GregorianCalendar gc;
    private int thisYear;
    private int thisMonth;
    private int today;
    private int selectedDay;
    private static JDialog dialog;
    private static GregorianCalendar retcod;

    private DateChooserDialog() {
        this(new GregorianCalendar(), Locale.getDefault());
    }

    private DateChooserDialog(GregorianCalendar calendar, Locale locale) {
        int i;
        this.gc = calendar;
        this.thisYear = this.gc.get(1);
        this.thisMonth = this.gc.get(2);
        this.today = this.selectedDay = this.gc.get(5);
        this.locale = locale;
        DateFormatSymbols dfs = DateFormatSymbols.getInstance(locale);
        this.monthStr = dfs.getMonths();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.anchor = 17;
        this.previousButton = new JButton();
        this.previousButton.setIcon(IconUtil.getImageIcon("/org/jphototagger/lib/resource/icons/icon_datechooser_prev.png"));
        this.previousButton.setBorder(BorderFactory.createEmptyBorder());
        this.previousButton.setPreferredSize(new Dimension(16, 16));
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DateChooserDialog.this.gc.add(2, -1);
                if (DateChooserDialog.this.selectedDay > DateChooserDialog.this.gc.getActualMaximum(5)) {
                    DateChooserDialog.this.selectedDay = 1;
                }
                DateChooserDialog.this.drawCalendar();
            }
        });
        this.add((Component)this.previousButton, c);
        ++c.gridx;
        c.anchor = 10;
        this.monthYearLabel = new JLabel("           ", 0);
        this.add((Component)this.monthYearLabel, c);
        ++c.gridx;
        c.anchor = 13;
        this.nextButton = new JButton();
        this.nextButton.setIcon(IconUtil.getImageIcon("/org/jphototagger/lib/resource/icons/icon_datechooser_next.png"));
        this.nextButton.setBorder(BorderFactory.createEmptyBorder());
        this.nextButton.setPreferredSize(new Dimension(16, 16));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                DateChooserDialog.this.gc.add(2, 1);
                if (DateChooserDialog.this.selectedDay > DateChooserDialog.this.gc.getActualMaximum(5)) {
                    DateChooserDialog.this.selectedDay = 1;
                }
                DateChooserDialog.this.drawCalendar();
            }
        });
        this.add((Component)this.nextButton, c);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                JLabel dayLabel = (JLabel)me.getSource();
                String str = dayLabel.getText();
                try {
                    int num = Integer.parseInt(str);
                    DateChooserDialog.this.gc.set(5, num);
                    DateChooserDialog.this.selectedDay = num;
                    DateChooserDialog.this.drawCalendar();
                }
                catch (Throwable t) {
                    Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, t);
                }
            }
        };
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        c.anchor = 10;
        JPanel panel = new JPanel(new GridLayout(7, 7, 1, 1));
        this.dayStr = dfs.getShortWeekdays();
        int firstDay = this.gc.getFirstDayOfWeek();
        for (i = 0; i < 7; ++i) {
            int x = firstDay + i;
            if (i == 6) {
                x = firstDay == 2 ? 1 : 7;
            }
            this.dayOfWeekLabels[i] = new JLabel(this.dayStr[x].toUpperCase(), 0);
            panel.add(this.dayOfWeekLabels[i]);
        }
        for (i = 0; i < this.dayOfMonthLabels.length; ++i) {
            this.dayOfMonthLabels[i] = new JLabel("  ", 0);
            this.dayOfMonthLabels[i].setOpaque(true);
            this.dayOfMonthLabels[i].addMouseListener(ml);
            panel.add(this.dayOfMonthLabels[i]);
        }
        this.drawCalendar();
        this.add((Component)panel, c);
    }

    private void drawCalendar() {
        int month = this.gc.get(2);
        int year = this.gc.get(1);
        this.monthYearLabel.setText(this.monthStr[month].toUpperCase() + " " + Integer.toString(year));
        this.gc.set(5, 1);
        int firstDayOfMonth = this.gc.get(7);
        if (this.gc.getFirstDayOfWeek() == 2) {
            --firstDayOfMonth;
        }
        this.gc.set(5, this.selectedDay);
        int day = 1;
        for (int i = 0; i < 42; ++i) {
            if (i >= firstDayOfMonth - 1 && i < this.gc.getActualMaximum(5) + firstDayOfMonth - 1) {
                this.dayOfMonthLabels[i].setText(Integer.toString(day));
                if (day == this.today && month == this.thisMonth && year == this.thisYear) {
                    this.dayOfMonthLabels[i].setForeground(Color.RED);
                } else {
                    this.dayOfMonthLabels[i].setForeground(Color.BLACK);
                }
                if (day == this.selectedDay) {
                    this.dayOfMonthLabels[i].setBackground(new Color(0xA0A0A0));
                } else {
                    this.dayOfMonthLabels[i].setBackground(Color.WHITE);
                }
                ++day;
                continue;
            }
            this.dayOfMonthLabels[i].setText("  ");
            this.dayOfMonthLabels[i].setBackground(new Color(0xE0E0E0));
        }
    }

    public GregorianCalendar getCalendar() {
        return new GregorianCalendar(this.gc.get(1), this.gc.get(2), this.selectedDay);
    }

    public void setCalendar(GregorianCalendar calendar) {
        if (calendar == null) {
            throw new NullPointerException("calendar == null");
        }
        this.gc = calendar;
        this.drawCalendar();
    }

    public static GregorianCalendar showDialog(Component comp, List<? extends Image> icons) {
        return DateChooserDialog.showDialog(comp, new GregorianCalendar(), Locale.getDefault(), icons);
    }

    public static GregorianCalendar showDialog(Component comp, GregorianCalendar calendar, Locale locale, List<? extends Image> icons) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = 0;
        c.gridx = 0;
        c.insets = new Insets(2, 2, 2, 2);
        c.gridwidth = 2;
        JFrame f = new JFrame();
        dialog = new JDialog(f, Bundle.getString(DateChooserDialog.class, "DateChooserDialog.title", new Object[0]), true);
        if (icons != null) {
            dialog.setIconImages(icons);
        }
        dialog.setLayout(new GridBagLayout());
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                retcod = null;
            }
        });
        final DateChooserDialog dc = new DateChooserDialog(calendar, locale);
        dialog.add((Component)dc, c);
        ++c.gridy;
        c.gridwidth = 1;
        c.anchor = 17;
        JButton okButton = new JButton(Bundle.getString(DateChooserDialog.class, "DateChooserDialog.okButton", new Object[0]));
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                retcod = dc.getCalendar();
                dialog.dispose();
            }
        });
        dialog.add((Component)okButton, c);
        ++c.gridx;
        c.anchor = 13;
        JButton cancelButton = new JButton(Bundle.getString(DateChooserDialog.class, "DateChooserDialog.cancelButton", new Object[0]));
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                retcod = null;
                dialog.dispose();
            }
        });
        dialog.add((Component)cancelButton, c);
        dialog.pack();
        dialog.setLocationRelativeTo(comp);
        dialog.setVisible(true);
        return retcod;
    }

    @Override
    public void setFont(Font font) {
        if (font == null) {
            throw new NullPointerException("font == null");
        }
        this.previousButton.setFont(font);
        this.nextButton.setFont(font);
        for (JLabel dayOfWeekLabel : this.dayOfWeekLabels) {
            dayOfWeekLabel.setFont(font);
        }
        for (JLabel dayOfMonthLabel : this.dayOfMonthLabels) {
            dayOfMonthLabel.setFont(font);
        }
        this.monthYearLabel.setFont(font);
    }
}

