/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.util;

import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public final class TreeUtil {
    public static DefaultMutableTreeNode findNodeContainingUserObjectRecursive(TreeNode parentNode, Object searchUserObject) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode == null");
        }
        if (TreeUtil.containsObject(parentNode, searchUserObject)) {
            return (DefaultMutableTreeNode)parentNode;
        }
        int childCount = parentNode.getChildCount();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            TreeNode childNode = parentNode.getChildAt(childIndex);
            DefaultMutableTreeNode foundNode = TreeUtil.findNodeContainingUserObjectRecursive(childNode, searchUserObject);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    private static boolean containsObject(TreeNode treeNode, Object userObject) {
        if (treeNode instanceof DefaultMutableTreeNode) {
            Object nodeUserObject = ((DefaultMutableTreeNode)treeNode).getUserObject();
            return Objects.equals(nodeUserObject, userObject);
        }
        return false;
    }

    public static DefaultMutableTreeNode findNodeWithUserObject(DefaultMutableTreeNode parent, Object userObject) {
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        if (userObject == null) {
            return null;
        }
        Enumeration<TreeNode> nodes = parent.preorderEnumeration();
        while (nodes.hasMoreElements()) {
            Object userObjectNode;
            TreeNode node = nodes.nextElement();
            if (!(node instanceof DefaultMutableTreeNode) || (userObjectNode = ((DefaultMutableTreeNode)node).getUserObject()) == null || !userObject.equals(userObjectNode)) continue;
            return (DefaultMutableTreeNode)node;
        }
        return null;
    }

    public static boolean isRootItemPosition(MouseEvent evt) {
        JTree tree;
        TreePath mousePath;
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        if (evt.getSource() instanceof JTree && (mousePath = (tree = (JTree)evt.getSource()).getPathForLocation(evt.getX(), evt.getY())) != null) {
            Object root = tree.getModel().getRoot();
            Object mouseItem = mousePath.getLastPathComponent();
            if (root != null && mouseItem != null) {
                return root.equals(mouseItem);
            }
        }
        return false;
    }

    public static Map<JTree, List<TreePath>> clearSelection(List<JTree> trees) {
        if (trees == null) {
            throw new NullPointerException("trees == null");
        }
        HashMap<JTree, List<TreePath>> selectionPaths = new HashMap<JTree, List<TreePath>>();
        for (JTree tree : trees) {
            if (tree.getSelectionCount() <= 0) continue;
            TreePath[] paths = tree.getSelectionPaths();
            if (paths != null && paths.length > 0) {
                selectionPaths.put(tree, Arrays.asList(paths));
            }
            tree.clearSelection();
        }
        return selectionPaths;
    }

    public static TreePath getTreePath(TreeModel treeModel, String pathString, String pathSeparator) {
        if (treeModel == null) {
            throw new NullPointerException("treeModel == null");
        }
        if (pathString == null) {
            throw new NullPointerException("pathString == null");
        }
        if (pathSeparator == null) {
            throw new NullPointerException("pathSeparator == null");
        }
        StringTokenizer tokenizer = new StringTokenizer(pathString, pathSeparator);
        int tokenCount = tokenizer.countTokens();
        int tokenFoundCount = 0;
        Object[] path = new Object[tokenCount > 0 ? tokenCount : 1];
        if (tokenCount > 0) {
            path[0] = treeModel.getRoot();
            tokenizer.nextToken();
            Object currentElement = treeModel.getRoot();
            boolean appended = true;
            for (int tokenNumber = 1; appended && tokenNumber < tokenCount; ++tokenNumber) {
                int childCount = treeModel.getChildCount(currentElement);
                String pathToken = tokenizer.nextToken();
                boolean found = false;
                appended = false;
                for (int index = 0; index < childCount && !found; ++index) {
                    Object childElement = treeModel.getChild(currentElement, index);
                    found = childElement.toString().equals(pathToken);
                    if (!found) continue;
                    path[tokenNumber] = childElement;
                    currentElement = childElement;
                    appended = true;
                    ++tokenFoundCount;
                }
            }
        }
        return tokenCount > 0 && tokenCount - 1 == tokenFoundCount ? new TreePath(path) : null;
    }

    public static void expandPath(JTree tree, TreePath path) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        TreePath expandPath = path;
        if (tree.getModel().isLeaf(path.getLastPathComponent())) {
            expandPath = path.getParentPath();
        }
        tree.expandPath(expandPath);
    }

    public static void expandPathCascade(JTree tree, TreePath path) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        if (path == null) {
            throw new NullPointerException("path == null");
        }
        Stack<TreePath> stack = new Stack<TreePath>();
        for (TreePath parent = path; parent != null; parent = parent.getParentPath()) {
            stack.push(parent);
        }
        while (!stack.isEmpty()) {
            tree.expandPath((TreePath)stack.pop());
        }
    }

    public static boolean existsPathBelow(DefaultMutableTreeNode parentNode, List<String> toStrings, boolean ignoreCase) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode == null");
        }
        if (toStrings == null) {
            throw new NullPointerException("toStrings == null");
        }
        int size = toStrings.size();
        DefaultMutableTreeNode node = parentNode;
        for (int i = 0; i < size; ++i) {
            String string = toStrings.get(i);
            if (string == null) {
                throw new NullPointerException("string == null. Element index: " + i);
            }
            if ((node = TreeUtil.getChild(node, string, ignoreCase)) != null) continue;
            return false;
        }
        return true;
    }

    public static DefaultMutableTreeNode getBestMatchingNodeBelow(DefaultMutableTreeNode parentNode, List<String> toStrings, boolean ignoreCase) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode == null");
        }
        if (toStrings == null) {
            throw new NullPointerException("toStrings == null");
        }
        int size = toStrings.size();
        DefaultMutableTreeNode node = parentNode;
        DefaultMutableTreeNode latest = parentNode;
        for (int i = 0; i < size && node != null; ++i) {
            String string = toStrings.get(i);
            if (string == null) {
                throw new NullPointerException("string == null. Element index: " + i);
            }
            if ((node = TreeUtil.getChild(node, string, ignoreCase)) == null) continue;
            latest = node;
        }
        return latest;
    }

    private static DefaultMutableTreeNode getChild(DefaultMutableTreeNode parentNode, String toString, boolean ignoreCase) {
        assert (toString != null);
        Enumeration<TreeNode> e = parentNode.children();
        while (e.hasMoreElements()) {
            TreeNode child = e.nextElement();
            if (!(child instanceof DefaultMutableTreeNode)) continue;
            if (child.toString() == null) {
                return null;
            }
            boolean exists = ignoreCase ? child.toString().equalsIgnoreCase(toString) : child.toString().equals(toString);
            if (!exists) continue;
            return (DefaultMutableTreeNode)child;
        }
        return null;
    }

    public static TreePath getTreePath(MouseEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        Object source = evt.getSource();
        if (source instanceof JTree) {
            int mousePosX = evt.getX();
            int mousePosY = evt.getY();
            return ((JTree)source).getPathForLocation(mousePosX, mousePosY);
        }
        return null;
    }

    public static TreePath getTreePath(File file, TreeModel model) {
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        Stack<DefaultMutableTreeNode> stack = new Stack<DefaultMutableTreeNode>();
        for (File parentFile = file; parentFile != null; parentFile = parentFile.getParentFile()) {
            stack.push(new DefaultMutableTreeNode(parentFile));
        }
        ArrayList<DefaultMutableTreeNode> nodes = new ArrayList<DefaultMutableTreeNode>(stack.size() + 1);
        nodes.add((DefaultMutableTreeNode)model.getRoot());
        while (!stack.isEmpty()) {
            nodes.add((DefaultMutableTreeNode)stack.pop());
        }
        return new TreePath(nodes.toArray());
    }

    public static void addNodesUserWithObject(Collection<? super DefaultMutableTreeNode> foundNodes, DefaultMutableTreeNode rootNode, Object userObject, int maxCount) {
        if (foundNodes == null) {
            throw new NullPointerException("foundNodes == null");
        }
        if (rootNode == null) {
            throw new NullPointerException("rootNode == null");
        }
        if (userObject == null) {
            throw new NullPointerException("userObject == null");
        }
        if (maxCount < 0) {
            throw new IllegalArgumentException("Negative max count: " + maxCount);
        }
        int foundNodeCount = foundNodes.size();
        Enumeration<TreeNode> children = rootNode.children();
        while (children.hasMoreElements() && foundNodeCount <= maxCount) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)children.nextElement();
            if (userObject.equals(child.getUserObject())) {
                foundNodes.add(child);
                continue;
            }
            TreeUtil.addNodesUserWithObject(foundNodes, child, userObject, maxCount);
        }
    }

    public static DefaultMutableTreeNode findChildNodeWithFile(DefaultMutableTreeNode parentNode, File file) {
        if (parentNode == null) {
            throw new NullPointerException("parentNode == null");
        }
        if (file == null) {
            throw new NullPointerException("file == null");
        }
        int childCount = parentNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            File f;
            DefaultMutableTreeNode node;
            Object userObject;
            TreeNode childNode = parentNode.getChildAt(i);
            if (!(childNode instanceof DefaultMutableTreeNode) || !((userObject = (node = (DefaultMutableTreeNode)childNode).getUserObject()) instanceof File) || !(f = (File)userObject).equals(file)) continue;
            return node;
        }
        return null;
    }

    public static void expandAll(JTree tree, boolean expand) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreeUtil.expandAll(tree, new TreePath(root), expand);
    }

    public static void expandAll(JTree tree, TreePath parent, boolean expand) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        if (parent == null) {
            throw new NullPointerException("parent == null");
        }
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                TreeUtil.expandAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static void expandAll(JTree tree, Collection<? extends TreePath> parentPaths, boolean expand) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        if (parentPaths == null) {
            throw new NullPointerException("parentPaths == null");
        }
        for (TreePath treePath : parentPaths) {
            TreeUtil.expandAll(tree, treePath, expand);
        }
    }

    public static void deselectAll(JTree tree) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        TreeSelectionModel m = tree.getSelectionModel();
        if (m != null) {
            m.clearSelection();
        }
    }

    public static boolean isAbove(TreeNode above, TreeNode below) {
        if (above == null) {
            throw new NullPointerException("above == null");
        }
        if (below == null) {
            throw new NullPointerException("below == null");
        }
        for (TreeNode parent = below.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != above) continue;
            return true;
        }
        return false;
    }

    public static boolean isMouseOverTreePath(MouseEvent evt, JTree tree) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        return tree.getRowForLocation(evt.getX(), evt.getY()) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAllChildren(DefaultTreeModel model, DefaultMutableTreeNode node) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        DefaultTreeModel defaultTreeModel = model;
        synchronized (defaultTreeModel) {
            int count = node.getChildCount();
            ArrayList<TreeNode> children = new ArrayList<TreeNode>(count);
            int[] indices = new int[count];
            for (int i = 0; i < count; ++i) {
                children.add(node.getChildAt(i));
                indices[i] = i;
            }
            node.removeAllChildren();
            model.nodesWereRemoved(node, indices, children.toArray());
        }
    }

    public static List<TreeNode> getTreeNodeChildren(TreeNode node) {
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        ArrayList<TreeNode> children = new ArrayList<TreeNode>(node.getChildCount());
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            TreeNode nextElement = enumeration.nextElement();
            if (!(nextElement instanceof TreeNode)) continue;
            children.add((DefaultMutableTreeNode)nextElement);
        }
        return children;
    }

    public static List<DefaultMutableTreeNode> getDefaultMutableTreeNodeChildren(TreeNode node) {
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        ArrayList<DefaultMutableTreeNode> children = new ArrayList<DefaultMutableTreeNode>(node.getChildCount());
        Enumeration<? extends TreeNode> enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            TreeNode nextElement = enumeration.nextElement();
            if (!(nextElement instanceof DefaultMutableTreeNode)) continue;
            children.add((DefaultMutableTreeNode)nextElement);
        }
        return children;
    }

    public static boolean isNodeExpanded(JTree tree, DefaultMutableTreeNode node) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        if (node == null) {
            throw new NullPointerException("node == null");
        }
        return tree.isExpanded(new TreePath(node.getPath()));
    }

    private TreeUtil() {
    }
}

