/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.util;

import java.awt.Component;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jphototagger.lib.util.StringUtil;

public final class TableUtil {
    private static final String HTML_LINE_BREAK = "<br />";

    public static void embedTableCellTextInHtml(JTable table, int row, JLabel label, String text, int maxCharsPerLine, String style) {
        if (table == null) {
            throw new NullPointerException("table == null");
        }
        if (label == null) {
            throw new NullPointerException("label == null");
        }
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        if (style == null) {
            throw new NullPointerException("style == null");
        }
        if (maxCharsPerLine <= 0) {
            throw new IllegalArgumentException("Negative max chars: " + maxCharsPerLine);
        }
        List<String> lines = StringUtil.wrapWords(text, maxCharsPerLine);
        StringBuilder sb = new StringBuilder("<html><style type=\"text/css\">body { " + style + " }</style></head><body>");
        int lineCount = lines.size();
        for (int i = 0; i < lineCount; ++i) {
            sb.append(i == 0 ? lines.get(i) : HTML_LINE_BREAK + lines.get(i));
        }
        sb.append("</body></html>");
        label.setText(sb.toString());
        int preferredHeight = label.getPreferredSize().height;
        if (preferredHeight > table.getRowHeight(row)) {
            table.setRowHeight(row, preferredHeight);
        }
    }

    public static void resizeColumnWidthsToFit(JTable table) {
        if (table == null) {
            throw new NullPointerException("table == null");
        }
        TableModel model = table.getModel();
        TableColumnModel colModel = table.getColumnModel();
        int columnCount = model.getColumnCount();
        int longestCell = 0;
        for (int colIndex = 0; colIndex < columnCount; ++colIndex) {
            TableColumn column = colModel.getColumn(colIndex);
            for (int rowIndex = 0; rowIndex < model.getRowCount(); ++rowIndex) {
                Object value = model.getValueAt(rowIndex, colIndex);
                if (value == null) continue;
                Component cell = table.getDefaultRenderer(model.getColumnClass(colIndex)).getTableCellRendererComponent(table, value, false, false, rowIndex, colIndex);
                int width = cell.getPreferredSize().width;
                if (width <= longestCell) continue;
                longestCell = width;
            }
            TableUtil.setColumnWidth(longestCell + 2, column);
            longestCell = 0;
        }
    }

    private static void setColumnWidth(int width, TableColumn column) {
        column.setPreferredWidth(width);
    }

    private TableUtil() {
    }
}

