/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.util;

import javax.swing.JTabbedPane;
import org.jphototagger.lib.swing.util.MnemonicIndexString;
import org.jphototagger.lib.swing.util.MnemonicUtil;

public final class TabbedPaneUtil {
    public static void setMnemonics(JTabbedPane pane) {
        if (pane == null) {
            throw new NullPointerException("pane == null");
        }
        int tabCount = pane.getTabCount();
        for (int tabIndex = 0; tabIndex < tabCount; ++tabIndex) {
            String title = pane.getTitleAt(tabIndex);
            if (title == null || title.length() <= 1) continue;
            MnemonicIndexString mnemonicIndexString = MnemonicUtil.getMnemonic(title);
            if (mnemonicIndexString.index == -1) continue;
            pane.setTitleAt(tabIndex, mnemonicIndexString.string);
            pane.setMnemonicAt(tabIndex, mnemonicIndexString.index);
        }
    }

    private TabbedPaneUtil() {
    }
}

