/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import org.jphototagger.lib.swing.util.MnemonicIndexString;
import org.jphototagger.lib.swing.util.TabbedPaneUtil;

public final class MnemonicUtil {
    private static final Map<Character, Integer> MNEMONIC_OF_CHAR = new HashMap<Character, Integer>();

    public static int getMnemonicOf(char c) {
        if (!MnemonicUtil.isInRange(c)) {
            throw new IllegalArgumentException("Character is not in Range: " + c);
        }
        return MNEMONIC_OF_CHAR.get(Character.valueOf(c));
    }

    public static boolean isInRange(char c) {
        return MNEMONIC_OF_CHAR.containsKey(Character.valueOf(c));
    }

    static MnemonicIndexString getMnemonic(String string) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        MnemonicIndexString noMnemonicIndexString = new MnemonicIndexString(-1, string);
        if (string.length() < 2) {
            return noMnemonicIndexString;
        }
        int strlen = string.length();
        int ampersandIndex = string.indexOf(38);
        if (ampersandIndex < 0) {
            return noMnemonicIndexString;
        }
        if (strlen < 2 || ampersandIndex < 0 || ampersandIndex > strlen - 2) {
            return noMnemonicIndexString;
        }
        char mnemonicChar = string.substring(ampersandIndex + 1, ampersandIndex + 2).toUpperCase().charAt(0);
        boolean isInRange = MnemonicUtil.isInRange(mnemonicChar);
        assert (isInRange) : "Not in Range: " + mnemonicChar + " of " + string;
        if (isInRange) {
            int mnemonic = MnemonicUtil.getMnemonicOf(mnemonicChar);
            String titlePrefix = ampersandIndex == 0 ? "" : string.substring(0, ampersandIndex);
            String titlePostfix = ampersandIndex == strlen - 1 ? "" : string.substring(ampersandIndex + 1);
            return new MnemonicIndexString(mnemonic, titlePrefix + titlePostfix);
        }
        return noMnemonicIndexString;
    }

    public static char getNotExistingMnemonicChar(String string, Collection<? extends Character> existingMnemonicChars) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        if (existingMnemonicChars == null) {
            throw new NullPointerException("existingMnemonicChars == null");
        }
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Empty string!");
        }
        int len = string.length();
        boolean doesExist = true;
        boolean inRange = false;
        char mnemonic = '\u0000';
        for (int index = 0; (!inRange || doesExist) && index < len; ++index) {
            mnemonic = string.substring(index, index + 1).toUpperCase().charAt(0);
            doesExist = existingMnemonicChars.contains(Character.valueOf(mnemonic));
            inRange = MnemonicUtil.isInRange(mnemonic);
        }
        return mnemonic;
    }

    public static void setMnemonics(Container container) {
        if (container == null) {
            throw new NullPointerException("container == null");
        }
        int count = container.getComponentCount();
        MnemonicUtil.setMnemonics((Component)container);
        for (int i = 0; i < count; ++i) {
            Component component = container.getComponent(i);
            MnemonicUtil.setMnemonics(component);
            if (!(component instanceof Container)) continue;
            MnemonicUtil.setMnemonics((Container)component);
        }
    }

    public static void setMnemonics(Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        if (component instanceof JLabel) {
            MnemonicIndexString mnemonicIndexString;
            JLabel label = (JLabel)component;
            String text = label.getText();
            if (text != null && !MnemonicUtil.isHtmlText(text) && MnemonicUtil.hasMnemonic(mnemonicIndexString = MnemonicUtil.getMnemonic(text))) {
                label.setText(mnemonicIndexString.string);
                label.setDisplayedMnemonic(mnemonicIndexString.index);
            }
        } else if (component instanceof AbstractButton) {
            MnemonicIndexString mnemonicIndexString;
            AbstractButton button = (AbstractButton)component;
            String text = button.getText();
            if (text != null && !MnemonicUtil.isHtmlText(text) && MnemonicUtil.hasMnemonic(mnemonicIndexString = MnemonicUtil.getMnemonic(text))) {
                button.setText(mnemonicIndexString.string);
                button.setMnemonic(mnemonicIndexString.index);
            }
        } else if (component instanceof JTabbedPane) {
            TabbedPaneUtil.setMnemonics((JTabbedPane)component);
        }
    }

    private static boolean isHtmlText(String string) {
        String lcString = string == null ? "" : string.toLowerCase().trim();
        return lcString.startsWith("<html");
    }

    private static boolean hasMnemonic(MnemonicIndexString p) {
        return MNEMONIC_OF_CHAR.containsValue(p.index);
    }

    public static List<Character> getMnemonicCharsOf(Collection<? extends Component> components) {
        if (components == null) {
            throw new NullPointerException("components == null");
        }
        ArrayList<Character> mnemonics = new ArrayList<Character>(components.size());
        for (Component component : components) {
            MnemonicUtil.setMnemonics(component);
            int mnemonic = 0;
            if (component instanceof JButton) {
                mnemonic = ((JButton)component).getMnemonic();
            } else if (component instanceof JLabel) {
                mnemonic = ((JLabel)component).getDisplayedMnemonic();
            }
            if (mnemonic <= 0) continue;
            mnemonics.add(Character.valueOf((char)mnemonic));
        }
        return mnemonics;
    }

    private MnemonicUtil() {
    }

    static {
        MNEMONIC_OF_CHAR.put(Character.valueOf('0'), 48);
        MNEMONIC_OF_CHAR.put(Character.valueOf('1'), 49);
        MNEMONIC_OF_CHAR.put(Character.valueOf('2'), 50);
        MNEMONIC_OF_CHAR.put(Character.valueOf('3'), 51);
        MNEMONIC_OF_CHAR.put(Character.valueOf('4'), 52);
        MNEMONIC_OF_CHAR.put(Character.valueOf('5'), 53);
        MNEMONIC_OF_CHAR.put(Character.valueOf('6'), 54);
        MNEMONIC_OF_CHAR.put(Character.valueOf('7'), 55);
        MNEMONIC_OF_CHAR.put(Character.valueOf('8'), 56);
        MNEMONIC_OF_CHAR.put(Character.valueOf('9'), 57);
        MNEMONIC_OF_CHAR.put(Character.valueOf('A'), 65);
        MNEMONIC_OF_CHAR.put(Character.valueOf('B'), 66);
        MNEMONIC_OF_CHAR.put(Character.valueOf('C'), 67);
        MNEMONIC_OF_CHAR.put(Character.valueOf('D'), 68);
        MNEMONIC_OF_CHAR.put(Character.valueOf('E'), 69);
        MNEMONIC_OF_CHAR.put(Character.valueOf('F'), 70);
        MNEMONIC_OF_CHAR.put(Character.valueOf('G'), 71);
        MNEMONIC_OF_CHAR.put(Character.valueOf('H'), 72);
        MNEMONIC_OF_CHAR.put(Character.valueOf('I'), 73);
        MNEMONIC_OF_CHAR.put(Character.valueOf('J'), 74);
        MNEMONIC_OF_CHAR.put(Character.valueOf('K'), 75);
        MNEMONIC_OF_CHAR.put(Character.valueOf('L'), 76);
        MNEMONIC_OF_CHAR.put(Character.valueOf('M'), 77);
        MNEMONIC_OF_CHAR.put(Character.valueOf('N'), 78);
        MNEMONIC_OF_CHAR.put(Character.valueOf('O'), 79);
        MNEMONIC_OF_CHAR.put(Character.valueOf('P'), 80);
        MNEMONIC_OF_CHAR.put(Character.valueOf('Q'), 81);
        MNEMONIC_OF_CHAR.put(Character.valueOf('R'), 82);
        MNEMONIC_OF_CHAR.put(Character.valueOf('S'), 83);
        MNEMONIC_OF_CHAR.put(Character.valueOf('T'), 84);
        MNEMONIC_OF_CHAR.put(Character.valueOf('U'), 85);
        MNEMONIC_OF_CHAR.put(Character.valueOf('V'), 86);
        MNEMONIC_OF_CHAR.put(Character.valueOf('W'), 87);
        MNEMONIC_OF_CHAR.put(Character.valueOf('X'), 88);
        MNEMONIC_OF_CHAR.put(Character.valueOf('Y'), 89);
        MNEMONIC_OF_CHAR.put(Character.valueOf('Z'), 90);
    }
}

