/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.util;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import org.jphototagger.lib.util.SystemUtil;

public final class MenuUtil {
    private static final String AMPERSAND = "&";

    private MenuUtil() {
    }

    public static void setMnemonics(JMenuBar menuBar) {
        if (menuBar == null) {
            throw new NullPointerException("menuBar == null");
        }
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            JMenu menu = menuBar.getMenu(i);
            if (menu == null) continue;
            MenuUtil.setMnemonicsToItems(menu);
        }
    }

    private static void setMnemonicsToItems(JMenu menu) {
        if (menu == null) {
            throw new NullPointerException("menu == null");
        }
        MenuUtil.setMnemonics(menu);
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (item == null) continue;
            MenuUtil.setMnemonics(item);
            if (!(item instanceof JMenu)) continue;
            MenuUtil.setMnemonicsToItems((JMenu)item);
        }
    }

    public static void setMnemonics(JMenuItem item) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        String itemText = item.getText();
        int itemTextLength = itemText.length();
        int ampersandIndex = itemText.indexOf(AMPERSAND);
        if (ampersandIndex >= 0 && ampersandIndex < itemTextLength - 1) {
            if (SystemUtil.isMac()) {
                MenuUtil.removeAmpersand(item, itemText, ampersandIndex);
            } else {
                MenuUtil.removeAmpersandSetMnemonic(item, itemText, ampersandIndex);
            }
        }
    }

    private static void removeAmpersandSetMnemonic(JMenuItem item, String itemText, int ampersandIndex) {
        char mnemonic = itemText.charAt(ampersandIndex + 1);
        int itemTextLength = itemText.length();
        String text = itemText.substring(0, ampersandIndex) + itemText.substring(ampersandIndex + 1, itemTextLength);
        item.setText(text);
        item.setMnemonic(mnemonic);
    }

    private static void removeAmpersand(JMenuItem item, String itemText, int ampersandIndex) {
        if (ampersandIndex == 0) {
            item.setText(itemText.substring(1));
        } else {
            item.setText(itemText.substring(0, ampersandIndex) + itemText.substring(ampersandIndex + 1));
        }
    }
}

