/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.util;

import java.awt.Color;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;

public final class LookAndFeelUtil {
    public static Color getUiColor(String propertyKey) {
        if (propertyKey == null) {
            throw new NullPointerException("propertyKey == null");
        }
        Color col = UIManager.getColor(propertyKey);
        return col == null ? null : new Color(col.getRGB());
    }

    public static void setSystemLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Throwable t) {
            Logger.getLogger(LookAndFeelUtil.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    public static void setCrossPlatformLookuAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Throwable t) {
            Logger.getLogger(LookAndFeelUtil.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private LookAndFeelUtil() {
    }
}

