/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.util;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import org.jdesktop.swingx.JXList;
import org.jphototagger.lib.util.ArrayUtil;

public final class ListUtil {
    private ListUtil() {
    }

    public static Map<JList<?>, List<?>> clearSelection(List<? extends JList> lists) {
        if (lists == null) {
            throw new NullPointerException("lists == null");
        }
        HashMap selectedIndices = new HashMap();
        for (JList jList : lists) {
            if (jList.isSelectionEmpty()) continue;
            List selValues = jList.getSelectedValuesList();
            if (!selValues.isEmpty()) {
                selectedIndices.put(jList, selValues);
            }
            jList.clearSelection();
        }
        return selectedIndices;
    }

    public static void setSelectedValues(JList<?> list, List<?> values) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        if (values == null) {
            throw new NullPointerException("values == null");
        }
        List<Integer> indices = ListUtil.getIndicesOfValues(list, values);
        list.setSelectedIndices(ArrayUtil.toIntArray(indices));
    }

    public static List<Integer> getIndicesOfValues(JList<?> list, List<?> values) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        if (values == null) {
            throw new NullPointerException("values == null");
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        ListModel<?> model = list.getModel();
        boolean isJXList = list instanceof JXList;
        boolean isDefaultListModel = model instanceof DefaultListModel;
        for (Object value : values) {
            if (value == null) continue;
            int index = -1;
            if (isDefaultListModel) {
                index = ((DefaultListModel)model).indexOf(value);
                if (index >= 0 && isJXList) {
                    index = ((JXList)list).convertIndexToView(index);
                }
            } else {
                for (int i = 0; index < 0 && i < model.getSize(); ++i) {
                    if (!value.equals(model.getElementAt(i))) continue;
                    index = i;
                }
            }
            if (index < 0) continue;
            indices.add(index);
        }
        return indices;
    }

    public static Object getFirstItemWithText(String text, DefaultListModel<?> model) {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        Object item = null;
        int size = model.size();
        for (int i = 0; i < size; ++i) {
            Object itemOfModel = model.get(i);
            if (!text.equals(itemOfModel.toString())) continue;
            return itemOfModel;
        }
        return item;
    }

    public static void setToken(String str, String delim, DefaultListModel<Object> model) {
        if (str == null) {
            throw new NullPointerException("str == null");
        }
        if (delim == null) {
            throw new NullPointerException("delim == null");
        }
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        StringTokenizer tokenizer = new StringTokenizer(str, delim);
        model.clear();
        while (tokenizer.hasMoreTokens()) {
            model.addElement(tokenizer.nextToken());
        }
    }

    public static String getTokenString(DefaultListModel<?> model, String delim) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (delim == null) {
            throw new NullPointerException("delim == null");
        }
        StringBuilder buffer = new StringBuilder();
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            buffer.append(model.get(i).toString()).append(i < size - 1 ? delim : "");
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void insertSorted(DefaultListModel<Object> model, T o, Comparator<T> c, int startIndex, int endIndex) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (o == null) {
            throw new NullPointerException("o == null");
        }
        if (c == null) {
            throw new NullPointerException("c == null");
        }
        DefaultListModel<Object> defaultListModel = model;
        synchronized (defaultListModel) {
            if (!model.contains(o)) {
                int size = model.getSize();
                boolean inserted = false;
                for (int i = startIndex; !inserted && i <= endIndex && i < size; ++i) {
                    if (c.compare(o, model.get(i)) >= 0) continue;
                    model.add(i, o);
                    inserted = true;
                }
                if (!inserted) {
                    model.addElement(o);
                }
            }
        }
    }

    public static boolean swapModelElements(DefaultListModel<Object> model, int indexFirstElement, int indexSecondElement) {
        boolean canSwap;
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        int size = model.getSize();
        boolean bl = canSwap = indexFirstElement >= 0 && indexFirstElement < size && indexSecondElement >= 0 && indexSecondElement < size && indexSecondElement != indexFirstElement;
        if (!canSwap) {
            return false;
        }
        Object firstElement = model.get(indexFirstElement);
        Object secondElement = model.get(indexSecondElement);
        model.set(indexFirstElement, secondElement);
        model.set(indexSecondElement, firstElement);
        return true;
    }

    public static boolean containsString(ListModel<?> model, String string) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            Object o = model.getElementAt(i);
            if (o == null || !o.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static int getItemIndex(MouseEvent evt) {
        if (evt == null) {
            throw new NullPointerException("evt == null");
        }
        Object source = evt.getSource();
        if (source instanceof JList) {
            int mousePosX = evt.getX();
            int mousePosY = evt.getY();
            return ((JList)source).locationToIndex(new Point(mousePosX, mousePosY));
        }
        return -1;
    }

    public static int getSelectionCount(JList<?> list) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        ListSelectionModel selectionModel = list.getSelectionModel();
        int minSelectionIndex = selectionModel.getMinSelectionIndex();
        int maxSelectionIndex = selectionModel.getMaxSelectionIndex();
        if (minSelectionIndex < 0 || maxSelectionIndex < 0) {
            return 0;
        }
        return maxSelectionIndex - minSelectionIndex + 1;
    }

    public static String getItemString(JList<?> list, int listIndex) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        if (listIndex >= 0) {
            Object o;
            int modelIndex = listIndex;
            if (list instanceof JXList) {
                modelIndex = ((JXList)list).convertIndexToModel(listIndex);
            }
            if ((o = list.getModel().getElementAt(modelIndex)) instanceof String) {
                return (String)o;
            }
        }
        return null;
    }

    public static List<String> toStringList(ListModel<?> model) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        int size = model.getSize();
        ArrayList<String> list = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            list.add(model.getElementAt(i).toString());
        }
        return list;
    }

    public static int select(JList<?> list, Object element, int startIndex) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        if (element == null) {
            throw new NullPointerException("element == null");
        }
        int selIndex = -1;
        ListModel<?> model = list.getModel();
        int size = model.getSize();
        for (int i = startIndex; selIndex == -1 && i < size; ++i) {
            Object o = model.getElementAt(i);
            if (!element.equals(o)) continue;
            selIndex = i;
        }
        if (selIndex >= 0) {
            list.setSelectedIndex(selIndex);
            list.ensureIndexIsVisible(selIndex);
        }
        return selIndex;
    }

    public static List<Integer> getExistingIndicesOf(int[] indices, JList<?> list) {
        if (indices == null) {
            throw new NullPointerException("indices == null");
        }
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        ArrayList<Integer> existingIndices = new ArrayList<Integer>(indices.length);
        int elementCount = list.getModel().getSize();
        for (int index : indices) {
            if (index < 0 || index >= elementCount) continue;
            existingIndices.add(index);
        }
        return existingIndices;
    }

    public static List<Integer> getModelIndicesOfItems(ListModel<?> model, Collection<? extends String> toStrings) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (toStrings == null) {
            throw new NullPointerException("toStrings == null");
        }
        ArrayList<Integer> indices = new ArrayList<Integer>(toStrings.size());
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            Object element = model.getElementAt(i);
            if (element == null || !toStrings.contains(element.toString())) continue;
            indices.add(i);
        }
        return indices;
    }

    public static void selectNearestIndex(JList<?> list, int index) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        if (index < 0) {
            throw new IllegalArgumentException("Negative index: " + index);
        }
        int size = list.getModel().getSize();
        if (size > 0) {
            list.setSelectedIndex(Math.min(size - 1, index));
        }
    }

    public static List<Integer> convertModelIndicesToListIndices(List<? extends Integer> modelIndices, JXList list) {
        if (modelIndices == null) {
            throw new NullPointerException("modelIndices == null");
        }
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        ArrayList<Integer> listIndices = new ArrayList<Integer>();
        for (Integer n : modelIndices) {
            int listIndex = list.convertIndexToView(n.intValue());
            listIndices.add(listIndex);
        }
        return listIndices;
    }

    public static <E> List<E> getElements(DefaultListModel<E> model) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        ArrayList<E> elements = new ArrayList<E>(model.size());
        Enumeration<E> e = model.elements();
        while (e.hasMoreElements()) {
            elements.add(e.nextElement());
        }
        return elements;
    }

    public static <E> void sort(DefaultListModel<E> model, Comparator<E> comp) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (comp == null) {
            throw new NullPointerException("comp == null");
        }
        List<E> elements = ListUtil.getElements(model);
        Collections.sort(elements, comp);
        model.clear();
        for (E element : elements) {
            model.addElement(element);
        }
    }
}

