/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.util;

import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jdesktop.swingx.JXList;
import org.jphototagger.lib.swing.MouseEventUtil;

public final class ListItemTempSelectionRowSetter
implements MouseListener,
PopupMenuListener {
    private final JList<?> list;
    private static final String TEMP_SEL_ROW_METHOD_NAME = "setTempSelectionRow";

    public ListItemTempSelectionRowSetter(JList<?> list, JPopupMenu popupMenu) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        if (popupMenu == null) {
            throw new NullPointerException("popupMenu == null");
        }
        this.list = list;
        this.listen(list, popupMenu);
    }

    private void listen(JList<?> list, JPopupMenu popupMenu) {
        list.addMouseListener(this);
        popupMenu.addPopupMenuListener(this);
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
        this.setRowIndex(-1);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (MouseEventUtil.isPopupTrigger(evt)) {
            int index = this.list.locationToIndex(new Point(evt.getX(), evt.getY()));
            if (index < 0) {
                return;
            }
            this.setRowIndex(index);
        }
    }

    private void setRowIndex(int index) {
        ListCellRenderer renderer = this.list.getCellRenderer();
        if (renderer instanceof JXList.DelegatingRenderer) {
            renderer = ((JXList.DelegatingRenderer)renderer).getDelegateRenderer();
        }
        if (this.hasMethod(renderer)) {
            try {
                Method m = renderer.getClass().getMethod(TEMP_SEL_ROW_METHOD_NAME, Integer.TYPE);
                m.invoke((Object)renderer, index);
                this.list.repaint();
            }
            catch (Throwable t) {
                Logger.getLogger(ListItemTempSelectionRowSetter.class.getName()).log(Level.SEVERE, null, t);
            }
        }
    }

    private boolean hasMethod(ListCellRenderer<?> renderer) {
        for (Method method : renderer.getClass().getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            if (!method.getName().equals(TEMP_SEL_ROW_METHOD_NAME) || (parameterTypes = method.getParameterTypes()).length != 1 || !parameterTypes[0].equals(Integer.TYPE)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent evt) {
    }
}

