/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ComponentUtil {
    public static void forceRepaint(Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        component.invalidate();
        component.validate();
        component.repaint();
    }

    public static void centerScreen(Window window) {
        if (window == null) {
            throw new NullPointerException("window == null");
        }
        Dimension screenDimension = window.getToolkit().getScreenSize();
        Rectangle frameBounds = window.getBounds();
        window.setLocation((screenDimension.width - frameBounds.width) / 2, (screenDimension.height - frameBounds.height) / 2);
    }

    public static List<Frame> findFramesWithIcons() {
        Frame[] allFrames;
        ArrayList<Frame> frames = new ArrayList<Frame>();
        for (Frame frame : allFrames = Frame.getFrames()) {
            if (frame.getIconImage() == null) continue;
            frames.add(frame);
        }
        return frames;
    }

    public static Frame findFrameWithIcon() {
        List<Frame> frames = ComponentUtil.findFramesWithIcons();
        return frames.isEmpty() ? null : frames.get(0);
    }

    public static <T> List<T> getAllOf(Container container, Class<T> clazz) {
        if (container == null) {
            throw new NullPointerException("container == null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz == null");
        }
        ArrayList components = new ArrayList();
        ComponentUtil.addAllOf(container, clazz, components);
        return components;
    }

    private static <T> void addAllOf(Container container, Class<T> clazz, List<T> all) {
        int count = container.getComponentCount();
        if (container.getClass().equals(clazz)) {
            all.add(container);
        }
        for (int i = 0; i < count; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof Container) {
                ComponentUtil.addAllOf((Container)component, clazz, all);
                continue;
            }
            if (!component.getClass().equals(clazz)) continue;
            all.add(component);
        }
    }

    public static <T> List<T> getAllOfExclude(Container container, Class<T> clazz, Collection<? extends Component> exclude) {
        if (container == null) {
            throw new NullPointerException("container == null");
        }
        if (clazz == null) {
            throw new NullPointerException("clazz == null");
        }
        if (exclude == null) {
            throw new NullPointerException("exclude == null");
        }
        ArrayList components = new ArrayList();
        ComponentUtil.addAllOfExclude(container, clazz, components, exclude);
        return components;
    }

    private static <T> void addAllOfExclude(Container container, Class<T> clazz, List<T> all, Collection<? extends Component> exclude) {
        if (exclude.contains(container)) {
            return;
        }
        if (container.getClass().equals(clazz)) {
            all.add(container);
        }
        int count = container.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component component = container.getComponent(i);
            if (exclude.contains(component)) continue;
            if (component instanceof Container) {
                ComponentUtil.addAllOfExclude((Container)component, clazz, all, exclude);
                continue;
            }
            if (!component.getClass().equals(clazz)) continue;
            all.add(component);
        }
    }

    public static void show(Window window) {
        if (window == null) {
            throw new NullPointerException("window == null");
        }
        if (!window.isVisible()) {
            window.setVisible(true);
        }
        window.toFront();
    }

    public static Font createBoldFont(Font font) {
        if (font == null) {
            throw new NullPointerException("font == null");
        }
        String fontName = font.getName();
        int fontSize = font.getSize();
        return new Font(fontName, 1, fontSize);
    }

    public static Frame findParentFrame(Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Frame)) continue;
            return (Frame)parent;
        }
        return null;
    }

    public static void parentWindowToFront(Component component) {
        if (component == null) {
            throw new NullPointerException("component == null");
        }
        for (Container parent = component.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Window)) continue;
            Window parentWindow = (Window)parent;
            parentWindow.toFront();
            return;
        }
    }

    private ComponentUtil() {
    }
}

