/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.util;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import org.jphototagger.lib.awt.EventQueueUtil;

public final class ComboBoxUtil {
    public static boolean hasItem(ComboBoxModel<?> comboBox, String string) {
        if (comboBox == null) {
            throw new NullPointerException("comboBox == null");
        }
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        for (int index = 0; index < comboBox.getSize(); ++index) {
            Object currentItem = comboBox.getElementAt(index);
            if (!currentItem.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static Object getItem(ComboBoxModel<?> comboBoxModel, String string) {
        if (comboBoxModel == null) {
            throw new NullPointerException("comboBoxModel == null");
        }
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        for (int index = 0; index < comboBoxModel.getSize(); ++index) {
            Object currentItem = comboBoxModel.getElementAt(index);
            if (!currentItem.equals(string)) continue;
            return currentItem;
        }
        return null;
    }

    public static void selectString(final ComboBoxModel<?> model, final String string) {
        if (model == null) {
            throw new NullPointerException("model == null");
        }
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                int size = model.getSize();
                Object selItem = model.getSelectedItem();
                for (int i = 0; i < size; ++i) {
                    Object element = model.getElementAt(i);
                    if (!(element instanceof String) || !((String)element).equals(string)) continue;
                    if (element != selItem) {
                        model.setSelectedItem(element);
                    }
                    return;
                }
            }
        });
    }

    public static boolean isValidIndex(JComboBox<?> comboBox, int index) {
        if (comboBox == null) {
            throw new NullPointerException("comboBox == null");
        }
        int itemCount = comboBox.getItemCount();
        return index >= 0 && index < itemCount;
    }

    private ComboBoxUtil() {
    }
}

