/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.util;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jphototagger.lib.util.CollectionUtil;

public final class Autocomplete
implements DocumentListener,
Serializable {
    private static final String COMMIT_ACTION = "commit";
    private static final String FOCUS_BACKWARD_ACTION = "focus_backward";
    private static final String FOCUS_FORWARD_ACTION = "focus_forward";
    private static final int MIN_CHARS = 2;
    private static final long serialVersionUID = 1L;
    private final LinkedList<String> words = new LinkedList();
    private volatile boolean transferFocusForwardOnEnter = true;
    private Mode mode = Mode.INSERT;
    private JTextArea textArea;
    private final boolean ignoreCase;

    public Autocomplete(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void decorate(JTextArea textArea, List<String> words, boolean sorted) {
        if (textArea == null) {
            throw new NullPointerException("textArea == null");
        }
        if (words == null) {
            throw new NullPointerException("words == null");
        }
        if (textArea != this.textArea) {
            this.textArea = textArea;
            textArea.getDocument().addDocumentListener(this);
            this.registerKeyStrokes();
        }
        Logger.getLogger(Autocomplete.class.getName()).log(Level.FINEST, "Autocomplete: Will decorating text area named ''{0}'' with {1} new words...", new Object[]{textArea.getName(), words.size()});
        LinkedList<String> linkedList = this.words;
        synchronized (linkedList) {
            this.words.clear();
            if (this.ignoreCase) {
                for (String word : words) {
                    this.words.add(word.toLowerCase());
                }
            } else {
                this.words.addAll(words);
            }
        }
        Logger.getLogger(Autocomplete.class.getName()).log(Level.FINEST, "Autocomplete: Decorated text area named ''{0}'' with {1} new words...", new Object[]{textArea.getName(), words.size()});
        this.init(sorted);
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setTransferFocusForward(boolean transfer) {
        this.transferFocusForwardOnEnter = transfer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(boolean sorted) {
        if (!sorted) {
            LinkedList<String> linkedList = this.words;
            synchronized (linkedList) {
                Collections.sort(this.words);
            }
        }
    }

    private void registerKeyStrokes() {
        InputMap im = this.textArea.getInputMap();
        ActionMap am = this.textArea.getActionMap();
        am.put(COMMIT_ACTION, new CommitAction());
        am.put(FOCUS_FORWARD_ACTION, new FocusForwardAction());
        am.put(FOCUS_BACKWARD_ACTION, new FocusBackwardAction());
        im.put(KeyStroke.getKeyStroke("ENTER"), COMMIT_ACTION);
        im.put(KeyStroke.getKeyStroke("shift ENTER"), FOCUS_BACKWARD_ACTION);
        im.put(KeyStroke.getKeyStroke("TAB"), FOCUS_FORWARD_ACTION);
        im.put(KeyStroke.getKeyStroke("shift TAB"), FOCUS_BACKWARD_ACTION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String word) {
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        LinkedList<String> linkedList = this.words;
        synchronized (linkedList) {
            if (!this.contains(word)) {
                String lcWord = this.ignoreCase ? word.toLowerCase() : word;
                CollectionUtil.binaryInsert(this.words, lcWord);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(String word) {
        if (word == null) {
            throw new NullPointerException("word == null");
        }
        LinkedList<String> linkedList = this.words;
        synchronized (linkedList) {
            String lcWord = this.ignoreCase ? word.toLowerCase() : word;
            return Collections.binarySearch(this.words, lcWord) >= 0;
        }
    }

    @Override
    public void changedUpdate(DocumentEvent ev) {
    }

    @Override
    public void removeUpdate(DocumentEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void insertUpdate(DocumentEvent ev) {
        int w;
        if (ev.getLength() != 1) {
            return;
        }
        int pos = ev.getOffset();
        String content = null;
        try {
            content = this.textArea.getText(0, pos + 1);
        }
        catch (Throwable t) {
            Logger.getLogger(Autocomplete.class.getName()).log(Level.SEVERE, null, t);
        }
        for (w = pos; w >= 0 && Character.isLetter(content.charAt(w)); --w) {
        }
        if (pos - w < 2) {
            return;
        }
        String prefix = content.substring(w + 1);
        if (this.ignoreCase) {
            prefix = prefix.toLowerCase();
        }
        LinkedList<String> linkedList = this.words;
        synchronized (linkedList) {
            int n = Collections.binarySearch(this.words, prefix);
            if (n < 0 && -n <= this.words.size()) {
                String match = this.words.get(-n - 1);
                if (match.startsWith(prefix)) {
                    String completion = match.substring(pos - w);
                    EventQueue.invokeLater(new CompletionTask(completion, pos + 1));
                }
            } else {
                this.mode = Mode.INSERT;
            }
        }
    }

    private class FocusForwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private FocusForwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Autocomplete.this.textArea.transferFocus();
        }
    }

    private class FocusBackwardAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private FocusBackwardAction() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Autocomplete.this.textArea.transferFocusBackward();
        }
    }

    private class CompletionTask
    implements Runnable {
        private final String completion;
        private final int position;

        CompletionTask(String completion, int position) {
            this.completion = completion;
            this.position = position;
        }

        @Override
        public void run() {
            Autocomplete.this.textArea.insert(this.completion, this.position);
            Autocomplete.this.textArea.setCaretPosition(this.position + this.completion.length());
            Autocomplete.this.textArea.moveCaretPosition(this.position);
            Autocomplete.this.mode = Mode.COMPLETION;
        }
    }

    private class CommitAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CommitAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (Autocomplete.this.mode == Mode.COMPLETION) {
                int pos = Autocomplete.this.textArea.getSelectionEnd();
                Autocomplete.this.textArea.insert(" ", pos);
                Autocomplete.this.textArea.setCaretPosition(pos + 1);
                Autocomplete.this.mode = Mode.INSERT;
            } else if (Autocomplete.this.transferFocusForwardOnEnter) {
                Autocomplete.this.textArea.transferFocus();
            }
        }
    }

    private static enum Mode {
        INSERT,
        COMPLETION;

    }
}

