/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.inputverifier;

import java.io.Serializable;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public final class StringPatternInputVerifier
extends InputVerifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String pattern;
    private final boolean trim;

    public StringPatternInputVerifier(String pattern) {
        this.pattern = pattern;
        this.trim = false;
    }

    public StringPatternInputVerifier(String pattern, boolean trim) {
        this.pattern = pattern;
        this.trim = trim;
    }

    @Override
    public boolean verify(JComponent input) {
        if (input instanceof JTextComponent) {
            return this.isValid((JTextComponent)input);
        }
        return true;
    }

    private boolean isValid(JTextComponent textComponent) {
        String text = this.trim ? textComponent.getText().trim() : textComponent.getText();
        return text.matches(this.pattern);
    }
}

