/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.inputverifier;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.jphototagger.lib.util.Bundle;

public final class NumberRangeInputVerifier
extends InputVerifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final double min;
    private final double max;
    private boolean message = true;

    public NumberRangeInputVerifier(double min, double max) {
        if (max < min) {
            throw new IllegalArgumentException("Maximum is less than minimum! " + max + " < " + min);
        }
        this.min = min;
        this.max = max;
    }

    public void setDisplayMessage(boolean display) {
        this.message = display;
    }

    @Override
    public boolean verify(JComponent component) {
        boolean lengthOk = this.lengthOk(component);
        if (!lengthOk) {
            this.errorMessage(component);
        }
        return lengthOk;
    }

    private boolean lengthOk(JComponent component) {
        String string = this.getString(component);
        if (string.isEmpty()) {
            return true;
        }
        Double value = this.toDouble(string);
        if (value == null) {
            return false;
        }
        return value >= this.min && value <= this.max;
    }

    private String getString(JComponent component) {
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).getText().trim();
        }
        return "";
    }

    private Double toDouble(String string) {
        try {
            return Double.valueOf(string);
        }
        catch (Throwable t) {
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "", t);
            return null;
        }
    }

    private void errorMessage(JComponent input) {
        if (!this.message) {
            return;
        }
        JOptionPane.showMessageDialog(input, Bundle.getString(NumberRangeInputVerifier.class, "NumberRangeInputVerifier.ErrorMessage", this.min, this.max), Bundle.getString(NumberRangeInputVerifier.class, "NumberRangeInputVerifier.Error.Title", new Object[0]), 0);
    }
}

