/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.inputverifier;

import java.awt.HeadlessException;
import java.io.Serializable;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;

public final class NumberInputVerifier
extends InputVerifier
implements Serializable {
    public static final NumberInputVerifier INSTANCE = new NumberInputVerifier();
    private static final long serialVersionUID = 1L;

    private NumberInputVerifier() {
    }

    @Override
    public boolean verify(JComponent input) {
        if (input instanceof JTextComponent && !this.isValid((JTextComponent)input)) {
            this.errorMessage();
            return false;
        }
        return true;
    }

    private void errorMessage() throws HeadlessException {
        JOptionPane.showMessageDialog(ComponentUtil.findFrameWithIcon(), Bundle.getString(NumberInputVerifier.class, "NumberInputVerifier.Error.NaN", new Object[0]), Bundle.getString(NumberInputVerifier.class, "NumberInputVerifier.Error.NaN.Title", new Object[0]), 0);
    }

    private boolean isValid(JTextComponent textComponent) {
        String text = textComponent.getText().trim();
        NumberFormat nf = NumberFormat.getInstance();
        try {
            nf.parse(text);
            return true;
        }
        catch (ParseException ex) {
            Logger.getLogger(NumberInputVerifier.class.getName()).log(Level.FINEST, ex.toString());
            return false;
        }
    }
}

