/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.inputverifier;

import java.io.Serializable;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.jphototagger.lib.util.Bundle;

public final class MaxLengthInputVerifier
extends InputVerifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final int maxLength;
    private boolean message = true;

    public MaxLengthInputVerifier(int maxLength) {
        if (maxLength < 0) {
            throw new IllegalArgumentException("maxLength < 0: " + maxLength);
        }
        this.maxLength = maxLength;
    }

    public void setDisplayMessage(boolean display) {
        this.message = display;
    }

    @Override
    public boolean verify(JComponent input) {
        boolean lengthOk = this.lengthOk(input);
        if (!lengthOk) {
            this.errorMessage(input);
        }
        return lengthOk;
    }

    private boolean lengthOk(JComponent component) {
        return this.getString(component).length() <= this.maxLength;
    }

    private String getString(JComponent component) {
        if (component instanceof JTextComponent) {
            return ((JTextComponent)component).getText().trim();
        }
        return "";
    }

    private void errorMessage(JComponent input) {
        if (!this.message) {
            return;
        }
        JOptionPane.showMessageDialog(input, Bundle.getString(MaxLengthInputVerifier.class, "MaxLengthInputVerifier.ErrorMessage", this.maxLength), Bundle.getString(MaxLengthInputVerifier.class, "MaxLengthInputVerifier.Error.Title", new Object[0]), 0);
    }
}

