/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.inputverifier;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public final class ForbiddenCharactersInputVerifier
extends InputVerifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Character> forbiddenCharacters = new ArrayList<Character>();

    public ForbiddenCharactersInputVerifier(Character ... forbidden) {
        this.forbiddenCharacters.addAll(Arrays.asList(forbidden));
    }

    @Override
    public boolean verify(JComponent input) {
        if (input instanceof JTextComponent) {
            return !this.containsOneOf((JTextComponent)input);
        }
        return true;
    }

    private boolean containsOneOf(JTextComponent tc) {
        String text = tc.getText();
        for (Character c : this.forbiddenCharacters) {
            if (text.indexOf(c.charValue()) < 0) continue;
            return true;
        }
        return false;
    }

    public String getChars() {
        StringBuilder sb = new StringBuilder();
        for (Character c : this.forbiddenCharacters) {
            sb.append(c);
        }
        return sb.toString();
    }
}

