/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing.inputverifier;

import java.awt.HeadlessException;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.text.JTextComponent;
import org.jphototagger.lib.swing.util.ComponentUtil;
import org.jphototagger.lib.util.Bundle;

public final class DateInputVerifier
extends InputVerifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String pattern;

    public DateInputVerifier() {
        this.pattern = null;
    }

    public DateInputVerifier(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public boolean verify(JComponent input) {
        if (input instanceof JTextComponent && !this.isValid((JTextComponent)input)) {
            this.errorMessage();
            return false;
        }
        return true;
    }

    private void errorMessage() throws HeadlessException {
        JOptionPane.showMessageDialog(ComponentUtil.findFrameWithIcon(), Bundle.getString(DateInputVerifier.class, "DateInputVerifier.Error.NaN", new Object[0]), Bundle.getString(DateInputVerifier.class, "DateInputVerifier.Error.NaN.Title", new Object[0]), 0);
    }

    private boolean isValid(JTextComponent textComponent) {
        String text = textComponent.getText().trim();
        DateFormat df = this.pattern == null ? DateFormat.getInstance() : new SimpleDateFormat(this.pattern);
        try {
            df.parse(text);
            return true;
        }
        catch (ParseException ex) {
            Logger.getLogger(DateInputVerifier.class.getName()).log(Level.FINEST, ex.toString());
            return false;
        }
    }
}

