/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.TreeNode;
import org.jphototagger.lib.util.ArrayUtil;

public final class UpdateInfoTreeModel {

    public static class NodesAndChildIndices {
        private final List<NodeAndChildIndices> info = new ArrayList<NodeAndChildIndices>();

        public void addNode(TreeNode node, int[] childrenIndices) {
            this.info.add(new NodeAndChildIndices(node, ArrayUtil.toList(childrenIndices)));
        }

        public void addNode(TreeNode node, int childIndex) {
            this.info.add(new NodeAndChildIndices(node, Arrays.asList(childIndex)));
        }

        public List<NodeAndChildIndices> getInfo() {
            return Collections.unmodifiableList(this.info);
        }
    }

    public static class NodeAndChild {
        private TreeNode node;
        private final Object[] updatedChildren = new Object[1];
        private final int[] updatedChildIndices = new int[1];

        public int[] getUpdatedChildIndex() {
            return Arrays.copyOf(this.updatedChildIndices, this.updatedChildIndices.length);
        }

        public Object[] getUpdatedChild() {
            return Arrays.copyOf(this.updatedChildren, this.updatedChildren.length);
        }

        public void setUpdatedChild(Object child, int index) {
            this.updatedChildren[0] = child;
            this.updatedChildIndices[0] = index;
        }

        public TreeNode getNode() {
            return this.node;
        }

        public void setNode(TreeNode node) {
            this.node = node;
        }
    }

    public static class NodeAndChildIndices {
        private TreeNode node;
        private List<Integer> childIndices = new ArrayList<Integer>();

        public NodeAndChildIndices() {
        }

        public NodeAndChildIndices(TreeNode node, List<Integer> childIndices) {
            this.node = node;
            this.childIndices = childIndices;
        }

        public int[] getChildIndices() {
            Collections.sort(this.childIndices);
            return ArrayUtil.toIntArray(this.childIndices);
        }

        public void addChildIndex(int index) {
            this.childIndices.add(index);
        }

        public TreeNode getNode() {
            return this.node;
        }

        public void setNode(TreeNode node) {
            this.node = node;
        }
    }
}

