/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JToggleButton;
import javax.swing.JTree;
import org.jphototagger.lib.swing.util.TreeUtil;
import org.jphototagger.lib.util.Bundle;

public final class TreeExpandCollapseAllAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    public static final String SELECTED_TEXT = Bundle.getString(TreeExpandCollapseAllAction.class, "TreeExpandCollapseAllAction.ToggleButton.Selected.Text", new Object[0]);
    public static final String NOT_SELECTED_TEXT = Bundle.getString(TreeExpandCollapseAllAction.class, "TreeExpandCollapseAllAction.ToggleButton.NotSelected.Text", new Object[0]);
    private final JTree tree;
    private final JToggleButton toggleButton;

    public TreeExpandCollapseAllAction(JToggleButton toggleButton, JTree tree) {
        super(NOT_SELECTED_TEXT);
        if (toggleButton == null) {
            throw new NullPointerException("toggleButton == null");
        }
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        this.toggleButton = toggleButton;
        this.tree = tree;
    }

    @Override
    public void actionPerformed(ActionEvent ignored) {
        boolean selected = this.toggleButton.isSelected();
        TreeUtil.expandAll(this.tree, selected);
        this.toggleButton.setText(selected ? SELECTED_TEXT : NOT_SELECTED_TEXT);
    }
}

