/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import org.jphototagger.lib.swing.util.MnemonicUtil;

public class TextComponentSearchPanel
extends JPanel
implements DocumentListener {
    private static final long serialVersionUID = 1L;
    private JTextComponent searchableTextComponent;
    private static final Color ERROR_BG = Color.RED;
    private final Color searchTextFieldBackground;
    private final transient Highlighter highlighter = new DefaultHighlighter();
    private final transient Highlighter.HighlightPainter painter = new DefaultHighlighter.DefaultHighlightPainter(Color.YELLOW);
    private final List<Integer> foundIndices = new ArrayList<Integer>();
    private int currentFoundIndex = -1;
    private JButton buttonSearchDownwards;
    private JButton buttonSearchUpwards;
    private JLabel label;
    private JTextField searchTextField;

    public TextComponentSearchPanel() {
        this.initComponents();
        MnemonicUtil.setMnemonics(this);
        this.searchTextFieldBackground = this.searchTextField.getBackground();
        this.listen();
    }

    private void listen() {
        this.searchTextField.getDocument().addDocumentListener(this);
    }

    public void setSearchableTextComponent(JTextComponent textComponent) {
        if (textComponent == null) {
            throw new NullPointerException("textComponent == null");
        }
        JTextComponent old = this.searchableTextComponent;
        this.searchableTextComponent = textComponent;
        textComponent.setHighlighter(this.highlighter);
        this.firePropertyChange("searchableTextComponent", old, this.searchableTextComponent);
    }

    public JTextComponent getSearchableTextComponent() {
        return this.searchableTextComponent;
    }

    public void setSearchPrompt(String prompt) {
        if (prompt == null) {
            throw new NullPointerException("prompt == null");
        }
        String old = this.label.getText();
        this.label.setText(prompt);
        MnemonicUtil.setMnemonics(this.label);
        this.firePropertyChange("searchPrompt", old, prompt);
    }

    public String getSearchPrompt() {
        return this.label.getText();
    }

    public void setSearchUpwardsButtonText(String text) {
        String old = this.buttonSearchUpwards.getText();
        this.buttonSearchUpwards.setText(text);
        MnemonicUtil.setMnemonics(this.buttonSearchUpwards);
        this.firePropertyChange("searchUpwardsButtonText", old, text);
    }

    public String getSearchUpwardsButtonText() {
        return this.buttonSearchUpwards.getText();
    }

    public void setSearchDownwardsButtonText(String text) {
        String old = this.buttonSearchDownwards.getText();
        this.buttonSearchDownwards.setText(text);
        MnemonicUtil.setMnemonics(this.buttonSearchDownwards);
        this.firePropertyChange("searchDownwardsButtonText", old, text);
    }

    public String getSearchDownwardsButtonText() {
        return this.buttonSearchDownwards.getText();
    }

    public void setSearchUpwardsButtonIcon(Icon icon) {
        Icon old = this.buttonSearchUpwards.getIcon();
        this.buttonSearchUpwards.setIcon(icon);
        this.firePropertyChange("searchUpwardsButtonIcon", old, icon);
    }

    public Icon getSearchUpwardsButtonIcon() {
        return this.buttonSearchUpwards.getIcon();
    }

    public void setSearchDownwardsButtonIcon(Icon icon) {
        Icon old = this.buttonSearchDownwards.getIcon();
        this.buttonSearchDownwards.setIcon(icon);
        this.firePropertyChange("searchDownwardsButtonIcon", old, icon);
    }

    public Icon getSearchDownwardsButtonIcon() {
        return this.buttonSearchDownwards.getIcon();
    }

    public void requestFocusToSearchTextField() {
        this.searchTextField.requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int search(int startIndex) {
        String searchText = this.searchTextField.getText().toLowerCase();
        if (this.searchableTextComponent == null || searchText.isEmpty()) {
            return -1;
        }
        this.highlighter.removeAllHighlights();
        String text = this.searchableTextComponent.getText().toLowerCase();
        int index = text.indexOf(searchText, startIndex);
        List<Integer> list = this.foundIndices;
        synchronized (list) {
            if (index >= startIndex) {
                try {
                    int end = index + searchText.length();
                    this.highlighter.addHighlight(index, end, this.painter);
                    this.searchableTextComponent.setCaretPosition(end);
                    this.searchTextField.setBackground(this.searchTextFieldBackground);
                    return index;
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(TextComponentSearchPanel.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else if (this.foundIndices.isEmpty()) {
                this.searchTextField.setBackground(ERROR_BG);
            }
        }
        return -1;
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.searchFromTextStart();
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.searchFromTextStart();
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.searchTextField.setEnabled(enabled);
        this.searchTextField.setEditable(enabled);
        if (!enabled) {
            this.buttonSearchUpwards.setEnabled(false);
            this.buttonSearchDownwards.setEnabled(false);
        }
        super.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchFromTextStart() {
        int foundIndex = this.search(0);
        boolean found = foundIndex >= 0;
        List<Integer> list = this.foundIndices;
        synchronized (list) {
            this.foundIndices.clear();
            if (found) {
                this.currentFoundIndex = foundIndex;
                if (!this.foundIndices.contains(foundIndex)) {
                    this.foundIndices.add(foundIndex);
                }
            }
        }
        this.buttonSearchDownwards.setEnabled(found);
        this.buttonSearchUpwards.setEnabled(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchDown() {
        if (this.searchableTextComponent == null) {
            return;
        }
        int foundIndex = this.search(this.currentFoundIndex + 1);
        boolean found = foundIndex > 0;
        List<Integer> list = this.foundIndices;
        synchronized (list) {
            if (found) {
                this.currentFoundIndex = foundIndex;
                if (!this.foundIndices.contains(foundIndex)) {
                    this.foundIndices.add(foundIndex);
                }
            }
            this.buttonSearchDownwards.setEnabled(found);
            this.buttonSearchUpwards.setEnabled(found || !found && !this.foundIndices.isEmpty());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchUp() {
        List<Integer> list = this.foundIndices;
        synchronized (list) {
            if (this.searchableTextComponent == null || this.foundIndices.isEmpty()) {
                return;
            }
            int indexCurFoundIndex = this.foundIndices.indexOf(this.currentFoundIndex);
            int prevFoundIndex = -1;
            if (indexCurFoundIndex > 0) {
                boolean found;
                prevFoundIndex = this.search(this.foundIndices.get(indexCurFoundIndex - 1));
                boolean bl = found = prevFoundIndex >= 0;
                if (found) {
                    this.currentFoundIndex = prevFoundIndex;
                }
                this.buttonSearchUpwards.setEnabled(this.foundIndices.indexOf(prevFoundIndex) > 0);
                this.buttonSearchDownwards.setEnabled(found);
            }
        }
    }

    private void initComponents() {
        this.label = new JLabel();
        this.searchTextField = new JTextField();
        this.buttonSearchDownwards = new JButton();
        this.buttonSearchUpwards = new JButton();
        this.setName("Form");
        this.label.setLabelFor(this.searchTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/lib/swing/Bundle");
        this.label.setText(bundle.getString("TextComponentSearchPanel.label.text"));
        this.label.setName("label");
        this.searchTextField.setColumns(10);
        this.searchTextField.setName("searchTextField");
        this.buttonSearchDownwards.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_arrow_down.png")));
        this.buttonSearchDownwards.setText(bundle.getString("TextComponentSearchPanel.buttonSearchDownwards.text"));
        this.buttonSearchDownwards.setEnabled(false);
        this.buttonSearchDownwards.setName("buttonSearchDownwards");
        this.buttonSearchDownwards.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextComponentSearchPanel.this.buttonSearchDownwardsActionPerformed(evt);
            }
        });
        this.buttonSearchUpwards.setIcon(new ImageIcon(this.getClass().getResource("/org/jphototagger/lib/resource/icons/icon_arrow_up.png")));
        this.buttonSearchUpwards.setText(bundle.getString("TextComponentSearchPanel.buttonSearchUpwards.text"));
        this.buttonSearchUpwards.setEnabled(false);
        this.buttonSearchUpwards.setName("buttonSearchUpwards");
        this.buttonSearchUpwards.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TextComponentSearchPanel.this.buttonSearchUpwardsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.searchTextField, -1, 118, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSearchDownwards).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSearchUpwards)));
        layout.linkSize(0, this.buttonSearchDownwards, this.buttonSearchUpwards);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.label).addComponent(this.searchTextField, -2, -1, -2).addComponent(this.buttonSearchDownwards).addComponent(this.buttonSearchUpwards)));
        layout.linkSize(1, this.buttonSearchDownwards, this.buttonSearchUpwards);
    }

    private void buttonSearchDownwardsActionPerformed(ActionEvent evt) {
        this.searchDown();
    }

    private void buttonSearchUpwardsActionPerformed(ActionEvent evt) {
        this.searchUp();
    }
}

