/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTable;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.table.TableStringConverter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jphototagger.lib.util.StringUtil;

public final class TableTextFilter
implements DocumentListener {
    private final JTable table;
    private final TableStringConverter tableStringConverter;

    public TableTextFilter(JTable table, TableStringConverter tableStringConverter) {
        if (table == null) {
            throw new NullPointerException("table == null");
        }
        if (tableStringConverter == null) {
            throw new NullPointerException("tableStringConverter == null");
        }
        this.table = table;
        this.tableStringConverter = tableStringConverter;
    }

    private void filterText(String text) {
        String trimmedText = text.trim();
        try {
            RowSorter<? extends TableModel> rowSorter = this.table.getRowSorter();
            if (rowSorter instanceof TableRowSorter) {
                TableRowSorter tableRowSorter = (TableRowSorter)rowSorter;
                tableRowSorter.setRowFilter(trimmedText.isEmpty() ? null : new ContainsStringRowFilter(trimmedText));
            }
        }
        catch (Throwable throwable) {
            Logger.getLogger(TableTextFilter.class.getName()).log(Level.SEVERE, null, throwable);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.filterDocument(e.getDocument());
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.filterDocument(e.getDocument());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.filterDocument(e.getDocument());
    }

    private void filterDocument(Document document) {
        if (document != null) {
            int length = document.getLength();
            if (length > 0) {
                try {
                    String text = document.getText(0, length);
                    this.filterText(text);
                }
                catch (BadLocationException ex) {
                    Logger.getLogger(TableTextFilter.class.getName()).log(Level.SEVERE, null, ex);
                }
            } else {
                this.filterText("");
            }
        }
    }

    private class ContainsStringRowFilter
    extends RowFilter<TableModel, Integer> {
        private final String string;

        ContainsStringRowFilter(String string) {
            this.string = string.toLowerCase();
        }

        @Override
        public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
            int row = entry.getIdentifier();
            TableModel model = entry.getModel();
            int columnCount = model.getColumnCount();
            for (int column = 0; column < columnCount; ++column) {
                String value = TableTextFilter.this.tableStringConverter.toString(model, row, column);
                String lowerCaseValue = StringUtil.toStringNullToEmptyString(value).toLowerCase();
                if (!lowerCaseValue.contains(this.string)) continue;
                return true;
            }
            return false;
        }
    }
}

