/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractButton;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public final class TableMouseClicker {
    private final JTable table;
    private final MouseListener tableButtonListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            Object value;
            Point point = e.getPoint();
            int column = TableMouseClicker.this.table.columnAtPoint(point);
            int row = TableMouseClicker.this.table.rowAtPoint(point);
            if (row >= 0 && column >= 0 && (value = TableMouseClicker.this.table.getValueAt(row, column)) instanceof AbstractButton) {
                ((AbstractButton)value).doClick();
            }
        }
    };

    public TableMouseClicker(JTable table) {
        if (table == null) {
            throw new NullPointerException("table == null");
        }
        this.table = table;
        this.listen();
    }

    private void listen() {
        this.table.addMouseListener(this.tableButtonListener);
    }

    public static class Renderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value instanceof AbstractButton) {
                return (AbstractButton)value;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

