/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.SwingUtilities;

public final class TableButtonMouseListener
implements MouseListener {
    private final JTable table;

    private void forwardEventToButton(MouseEvent evt) {
        JButton button = this.getButton(evt);
        if (button != null) {
            MouseEvent mouseEvent = SwingUtilities.convertMouseEvent(this.table, evt, button);
            button.dispatchEvent(mouseEvent);
            this.table.repaint();
        }
    }

    private JButton getButton(MouseEvent evt) {
        int row = evt.getY() / this.table.getRowHeight();
        int column = this.table.getColumnModel().getColumnIndexAtX(evt.getX());
        if (row >= this.table.getRowCount() || row < 0 || column >= this.table.getColumnCount() || column < 0) {
            return null;
        }
        Object value = this.table.getValueAt(row, column);
        if (value instanceof JButton) {
            return (JButton)value;
        }
        return null;
    }

    public TableButtonMouseListener(JTable table) {
        if (table == null) {
            throw new NullPointerException("table == null");
        }
        this.table = table;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        JButton button = this.getButton(evt);
        if (button != null) {
            button.doClick();
        }
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
        this.forwardEventToButton(evt);
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        this.forwardEventToButton(evt);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.forwardEventToButton(evt);
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        this.forwardEventToButton(evt);
    }
}

