/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jphototagger.lib.util.StringUtil;

public class TabbedPaneSearchPanel
extends JPanel
implements ComponentListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    private final Map<String, Collection<Component>> tabsOfWord = new HashMap<String, Collection<Component>>();
    private final Collection<Component> tabsCache = new ArrayList<Component>();
    private final Map<Object, String> originalTextOf = new HashMap<Object, String>();
    private final Map<Component, JTabbedPane> paneOfTab = new HashMap<Component, JTabbedPane>();
    private final Map<Component, String> titleOfTab = new LinkedHashMap<Component, String>();
    private final DefaultListModel<Object> listModel = new DefaultListModel();
    private Component visibleComponent;
    private static final String HL_SPAN_START = "<span style=\"color:#000000; background:#ffff000;\">";
    private static final String HL_SPAN_END = "</span>";
    private JLabel labelSearch;
    private JList<Object> list;
    private JScrollPane scrollPane;
    private JTextField textFieldSearch;

    public TabbedPaneSearchPanel() {
        this.initComponents();
        this.listen();
    }

    private void listen() {
        this.textFieldSearch.getDocument().addDocumentListener(this);
    }

    private void clear() {
        this.listenToTabs(false);
        this.tabsOfWord.clear();
        this.paneOfTab.clear();
        this.titleOfTab.clear();
        this.listModel.clear();
        this.originalTextOf.clear();
        this.tabsCache.clear();
        this.textFieldSearch.setText("");
    }

    public void setParentPane(JTabbedPane pane) {
        if (pane == null) {
            throw new NullPointerException("pane == null");
        }
        this.clear();
        this.traversePane(pane);
        this.setAllTabsToListAndCache();
        this.visibleComponent = pane.getSelectedComponent();
        this.traverseGetOriginalTexts(this.visibleComponent);
        this.listenToTabs(true);
    }

    private void selectTab(Component tab) {
        JTabbedPane pane = this.paneOfTab.get(tab);
        if (pane != null) {
            pane.setSelectedComponent(tab);
            this.selectPaneOfPane(pane);
        }
    }

    private void selectPaneOfPane(JTabbedPane pane) {
        Component tab = this.getTabOfPane(pane);
        if (tab != null) {
            this.selectTab(tab);
        }
    }

    private Component getTabOfPane(JTabbedPane pane) {
        Container prevParent = pane;
        for (Container parent = pane.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof JTabbedPane) {
                return prevParent;
            }
            prevParent = parent;
        }
        return null;
    }

    private void traversePane(JTabbedPane pane) {
        int tabCount = pane.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Component tab = pane.getComponentAt(i);
            String tabTitle = pane.getTitleAt(i);
            this.titleOfTab.put(tab, tabTitle);
            this.paneOfTab.put(tab, pane);
            this.setWordsOf(tabTitle, tab);
            if (tab instanceof Container) {
                this.traverseContainer((Container)tab, tab);
                continue;
            }
            this.traverseComponent(tab, pane);
        }
    }

    private void traverseContainer(Container container, Component parentTab) {
        int componentCount = container.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            Component component = container.getComponent(i);
            if (component instanceof JTabbedPane) {
                this.traversePane((JTabbedPane)component);
                continue;
            }
            if (component instanceof Container) {
                this.traverseComponent(component, parentTab);
                this.traverseContainer((Container)component, parentTab);
                continue;
            }
            this.traverseComponent(component, parentTab);
        }
    }

    private void traverseComponent(Component component, Component parentTab) {
        Border border;
        if (component instanceof JLabel) {
            this.setWordsOf((JLabel)component, parentTab);
        } else if (component instanceof JCheckBox) {
            this.setWordsOf((JCheckBox)component, parentTab);
        } else if (component instanceof JRadioButton) {
            this.setWordsOf((JRadioButton)component, parentTab);
        }
        if (component instanceof JComponent && (border = ((JComponent)component).getBorder()) instanceof TitledBorder) {
            this.setWordsOf((TitledBorder)border, parentTab);
        }
    }

    private void setWordsOf(TitledBorder tBorder, Component tabOfBorder) {
        this.setWordsOf(tBorder.getTitle(), tabOfBorder);
    }

    private void setWordsOf(JRadioButton radioButton, Component tabOfRadioButton) {
        this.setWordsOf(radioButton.getText(), tabOfRadioButton);
    }

    private void setWordsOf(JCheckBox checkBox, Component tabOfCheckBox) {
        this.setWordsOf(checkBox.getText(), tabOfCheckBox);
    }

    private void setWordsOf(JLabel label, Component tabOfLabel) {
        this.setWordsOf(label.getText(), tabOfLabel);
    }

    private void setWordsOf(String wordsString, Component parentTab) {
        for (String word : StringUtil.getWordsOf(wordsString)) {
            this.setTabOfWord(word.toLowerCase(), parentTab);
        }
    }

    private void setTabOfWord(String word, Component parentTab) {
        Collection<Component> parentTabs = this.tabsOfWord.get(word);
        if (parentTabs == null) {
            parentTabs = new ArrayList<Component>();
        }
        if (!parentTabs.contains(parentTab)) {
            parentTabs.add(parentTab);
        }
        this.tabsOfWord.put(word, parentTabs);
    }

    public void addSearchWordsTo(Collection<? extends String> words, Component tab) {
        if (words == null) {
            throw new NullPointerException("words == null");
        }
        if (tab == null) {
            throw new NullPointerException("tab == null");
        }
        for (String string : words) {
            this.setTabOfWord(string, tab);
        }
    }

    public void focusSearchTextfield() {
        this.textFieldSearch.requestFocusInWindow();
    }

    private void search() {
        this.setToListTabsOfWord(this.textFieldSearch.getText().trim().toLowerCase());
    }

    private void setToListTabsOfWord(String word) {
        if (word.isEmpty()) {
            this.setAllTabsToListAndCache();
        } else {
            this.listModel.clear();
            for (Component tab : this.findTabs(word)) {
                this.listModel.addElement(tab);
            }
        }
    }

    private Collection<Component> findTabs(String word) {
        HashSet<Component> tabs = new HashSet<Component>();
        for (String wd : this.tabsOfWord.keySet()) {
            if (!wd.contains(word)) continue;
            tabs.addAll(this.tabsOfWord.get(wd));
        }
        return tabs;
    }

    private void setAllTabsToListAndCache() {
        this.listModel.clear();
        for (Component tab : this.titleOfTab.keySet()) {
            this.listModel.addElement(tab);
            this.tabsCache.add(tab);
        }
    }

    private void setTabOfSelectedListValue() {
        Object value = this.list.getSelectedValue();
        if (value instanceof Component) {
            this.selectTab((Component)value);
        }
    }

    private void listenToTabs(boolean listen) {
        for (Component component : this.tabsCache) {
            if (listen) {
                component.addComponentListener(this);
                continue;
            }
            component.removeComponentListener(this);
        }
    }

    @Override
    public void insertUpdate(DocumentEvent evt) {
        this.startSearch();
    }

    @Override
    public void removeUpdate(DocumentEvent evt) {
        this.startSearch();
    }

    @Override
    public void changedUpdate(DocumentEvent evt) {
        this.startSearch();
    }

    private void startSearch() {
        this.search();
        if (this.visibleComponent != null) {
            this.setSearchWordHighlighted(this.visibleComponent);
        }
    }

    @Override
    public void componentResized(ComponentEvent evt) {
    }

    @Override
    public void componentMoved(ComponentEvent evt) {
    }

    @Override
    public void componentShown(ComponentEvent evt) {
        this.visibleComponent = evt.getComponent();
        this.traverseGetOriginalTexts(this.visibleComponent);
        this.setSearchWordHighlighted(evt.getComponent());
    }

    @Override
    public void componentHidden(ComponentEvent evt) {
        this.setOriginalTexts();
        this.originalTextOf.clear();
        this.visibleComponent = null;
    }

    private void setOriginalTexts() {
        for (Object o : this.originalTextOf.keySet()) {
            String text = this.originalTextOf.get(o);
            if (o instanceof JLabel) {
                ((JLabel)o).setText(text);
                continue;
            }
            if (o instanceof JCheckBox) {
                ((JCheckBox)o).setText(text);
                continue;
            }
            if (o instanceof JRadioButton) {
                ((JRadioButton)o).setText(text);
                continue;
            }
            if (!(o instanceof TitledBorder)) continue;
            ((TitledBorder)o).setTitle(text);
        }
    }

    private void traverseGetOriginalTexts(Component component) {
        if (component instanceof Container) {
            Container container = (Container)component;
            this.getOriginalTextsOf(container);
            int compCount = container.getComponentCount();
            for (int i = 0; i < compCount; ++i) {
                this.traverseGetOriginalTexts(container.getComponent(i));
            }
        } else {
            this.getOriginalTextsOf(component);
        }
    }

    private void getOriginalTextsOf(Component component) {
        if (component instanceof JLabel) {
            this.originalTextOf.put(component, ((JLabel)component).getText());
        } else if (component instanceof JCheckBox) {
            this.originalTextOf.put(component, ((JCheckBox)component).getText());
        } else if (component instanceof JRadioButton) {
            this.originalTextOf.put(component, ((JRadioButton)component).getText());
        }
    }

    private void setSearchWordHighlighted(Component component) {
        this.setOriginalTexts();
        String word = this.textFieldSearch.getText().trim();
        if (word.isEmpty()) {
            return;
        }
        this.traverseHighlight(component, word);
    }

    private void traverseHighlight(Component component, String word) {
        if (component instanceof Container) {
            Container container = (Container)component;
            this.highlightIn(container, word);
            int compCount = container.getComponentCount();
            for (int i = 0; i < compCount; ++i) {
                this.traverseHighlight(container.getComponent(i), word);
            }
        } else {
            this.highlightIn(component, word);
        }
    }

    private void highlightIn(Component component, String word) {
        if (component instanceof JLabel) {
            JLabel lbl = (JLabel)component;
            if (lbl.getIcon() == null) {
                lbl.setText(this.getHighlighted(lbl.getText().trim(), word));
            }
        } else if (component instanceof JCheckBox) {
            JCheckBox cb = (JCheckBox)component;
            cb.setText(this.getHighlighted(cb.getText().trim(), word));
        } else if (component instanceof JRadioButton) {
            JRadioButton rb = (JRadioButton)component;
            rb.setText(this.getHighlighted(rb.getText().trim(), word));
        }
    }

    private String getHighlighted(String s, String word) {
        if (this.isHtml(s)) {
            return this.getHighlightedHtml(s, word);
        }
        return "<html>" + this.getHighlightedIn(s, word) + "</html>";
    }

    private boolean isHtml(String s) {
        return s.length() > 5 && s.substring(1, 5).toLowerCase().equals("html");
    }

    private String getHighlightedIn(String s, String word) {
        List<Integer> indices = this.getHighlightStartIndices(s, word);
        if (indices.isEmpty()) {
            return s;
        }
        StringBuilder sb = new StringBuilder();
        int wLen = word.length();
        int iSize = indices.size();
        int beforeWIndex = 0;
        for (int i = 0; i < iSize; ++i) {
            int wIndex = indices.get(i);
            if (beforeWIndex < wIndex) {
                sb.append(s.substring(beforeWIndex, wIndex));
            }
            beforeWIndex = wIndex + wLen;
            sb.append(HL_SPAN_START);
            sb.append(s.substring(wIndex, wIndex + wLen));
            sb.append(HL_SPAN_END);
        }
        if (beforeWIndex < s.length()) {
            sb.append(s.substring(beforeWIndex));
        }
        return sb.toString();
    }

    private List<Integer> getHighlightStartIndices(String s, String word) {
        String sLower = s.toLowerCase();
        String wLower = word.toLowerCase();
        int sLen = sLower.length();
        int wLen = word.length();
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int index = sLower.indexOf(wLower, 0);
        while (index >= 0) {
            indices.add(index);
            index = index + wLen < sLen ? sLower.indexOf(wLower, index + wLen) : -1;
        }
        return indices;
    }

    private String getHighlightedHtml(String s, String word) {
        StringBuilder sb = new StringBuilder();
        List<BeginEndIndex> validRanges = this.getValidRangesInHtml(s);
        int eIndexText = 0;
        int bIndexHtml = 0;
        if (validRanges.isEmpty()) {
            return s;
        }
        for (BeginEndIndex range : validRanges) {
            int eIndexHtml = range.beginIndex;
            if (StringUtil.isSubstring(s, bIndexHtml, eIndexHtml)) {
                sb.append(s.substring(bIndexHtml, eIndexHtml));
            }
            int bIndexText = range.beginIndex;
            bIndexHtml = eIndexText = range.endIndex + 1;
            if (!StringUtil.isSubstring(s, bIndexText, eIndexText)) continue;
            sb.append(this.getHighlightedIn(s.substring(bIndexText, eIndexText), word));
        }
        if (eIndexText < s.length() - 1) {
            sb.append(s.substring(eIndexText));
        }
        return sb.toString();
    }

    private List<BeginEndIndex> getValidRangesInHtml(String s) {
        ArrayList<BeginEndIndex> ranges = new ArrayList<BeginEndIndex>();
        int len = s.length();
        int start = 0;
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '<' && i > 0 && start < len) {
                ranges.add(new BeginEndIndex(start, i - 1));
                continue;
            }
            if (c != '>') continue;
            start = i + 1;
        }
        return ranges;
    }

    private void initComponents() {
        this.labelSearch = new JLabel();
        this.textFieldSearch = new JTextField();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.setName("Form");
        this.labelSearch.setDisplayedMnemonic('s');
        this.labelSearch.setLabelFor(this.textFieldSearch);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/lib/swing/Bundle");
        this.labelSearch.setText(bundle.getString("TabbedPaneSearchPanel.labelSearch.text"));
        this.labelSearch.setName("labelSearch");
        this.textFieldSearch.setColumns(10);
        this.textFieldSearch.setName("textFieldSearch");
        this.scrollPane.setName("scrollPane");
        this.list.setModel(this.listModel);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(new TabTitleRenderer());
        this.list.setName("list");
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                TabbedPaneSearchPanel.this.listValueChanged(evt);
            }
        });
        this.scrollPane.setViewportView(this.list);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.labelSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textFieldSearch, -1, 109, Short.MAX_VALUE)).addComponent(this.scrollPane, -1, 152, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelSearch).addComponent(this.textFieldSearch, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scrollPane, -1, 180, Short.MAX_VALUE)));
    }

    private void listValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            this.setTabOfSelectedListValue();
        }
    }

    private class TabTitleRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 1L;

        private TabTitleRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String tabTitle;
            JLabel label = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof Component && (tabTitle = (String)TabbedPaneSearchPanel.this.titleOfTab.get((Component)value)) != null) {
                label.setText(tabTitle);
            }
            return label;
        }
    }

    private static class BeginEndIndex {
        final int beginIndex;
        final int endIndex;

        BeginEndIndex(int beginIndex, int endIndex) {
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
        }
    }
}

