/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ResourceBundle;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.jphototagger.lib.awt.EventQueueUtil;
import org.jphototagger.lib.swing.TextComponentSearchPanel;
import org.jphototagger.lib.swing.util.MnemonicUtil;

public class SystemOutputPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static volatile int MAX_CHAR_COUNT = 100000;
    private static volatile int MAX_CHARS_EXESS = 1000;
    private boolean capture;
    private JButton buttonCopyToClipboard;
    private JButton buttonDelete;
    private JScrollPane scrollPane;
    private TextComponentSearchPanel searchPanel;
    private JTextArea textArea;

    public SystemOutputPanel() {
        this.initComponents();
        MnemonicUtil.setMnemonics(this);
    }

    public synchronized void caputure() {
        if (!this.capture) {
            this.redirectSystemStreams();
        }
    }

    private void copyToClipboard() {
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection(this.textArea.getText()), null);
    }

    private void deleteText() {
        this.textArea.setText("");
    }

    private void updateTextArea(final String text) {
        EventQueueUtil.invokeInDispatchThread(new Runnable(){

            @Override
            public void run() {
                SystemOutputPanel.this.textArea.append(text);
                SystemOutputPanel.this.textArea.setCaretPosition(SystemOutputPanel.this.textArea.getDocument().getLength());
                int excess = SystemOutputPanel.this.textArea.getDocument().getLength() - MAX_CHAR_COUNT;
                if (excess >= MAX_CHARS_EXESS) {
                    SystemOutputPanel.this.textArea.replaceRange("", 0, excess);
                }
            }
        });
    }

    public String getOutput() {
        return this.textArea.getText();
    }

    private void redirectSystemStreams() {
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                SystemOutputPanel.this.updateTextArea(String.valueOf((char)b));
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                SystemOutputPanel.this.updateTextArea(new String(b, off, len));
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }
        };
        System.setOut(new PrintStream(out, true));
        System.setErr(new PrintStream(out, true));
    }

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.textArea = new JTextArea();
        this.searchPanel = new TextComponentSearchPanel();
        this.searchPanel.setSearchableTextComponent(this.textArea);
        this.buttonDelete = new JButton();
        this.buttonCopyToClipboard = new JButton();
        this.setName("Form");
        this.scrollPane.setName("scrollPane");
        this.textArea.setColumns(1);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setTabSize(4);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setName("textArea");
        this.scrollPane.setViewportView(this.textArea);
        this.searchPanel.setName("searchPanel");
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/lib/swing/Bundle");
        this.buttonDelete.setText(bundle.getString("SystemOutputPanel.buttonDelete.text"));
        this.buttonDelete.setToolTipText(bundle.getString("SystemOutputPanel.buttonDelete.toolTipText"));
        this.buttonDelete.setName("buttonDelete");
        this.buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemOutputPanel.this.buttonDeleteActionPerformed(evt);
            }
        });
        this.buttonCopyToClipboard.setText(bundle.getString("SystemOutputPanel.buttonCopyToClipboard.text"));
        this.buttonCopyToClipboard.setToolTipText(bundle.getString("SystemOutputPanel.buttonCopyToClipboard.toolTipText"));
        this.buttonCopyToClipboard.setName("buttonCopyToClipboard");
        this.buttonCopyToClipboard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SystemOutputPanel.this.buttonCopyToClipboardActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.searchPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 138, Short.MAX_VALUE).addComponent(this.buttonDelete).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonCopyToClipboard)).addComponent(this.scrollPane, -1, 673, Short.MAX_VALUE));
        layout.linkSize(0, this.buttonCopyToClipboard, this.buttonDelete);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.scrollPane, -1, 79, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonCopyToClipboard).addComponent(this.buttonDelete)).addComponent(this.searchPanel, -2, -1, -2))));
        layout.linkSize(1, this.buttonCopyToClipboard, this.buttonDelete, this.searchPanel);
    }

    private void buttonCopyToClipboardActionPerformed(ActionEvent evt) {
        this.copyToClipboard();
    }

    private void buttonDeleteActionPerformed(ActionEvent evt) {
        this.deleteText();
    }
}

