/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.text.Collator;
import java.util.Collection;
import java.util.Collections;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

public final class SortedChildrenTreeNode
extends DefaultMutableTreeNode
implements Comparable<Object> {
    private static final long serialVersionUID = 1L;
    private static final Collator collator = Collator.getInstance();

    public SortedChildrenTreeNode() {
    }

    public SortedChildrenTreeNode(Object userObject) {
        super(userObject);
    }

    public SortedChildrenTreeNode(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
    }

    public void sortChildren() {
        Collections.sort(this.children);
    }

    public void insertUnsorted(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
    }

    @Override
    public void insert(MutableTreeNode newChild, int childIndex) {
        super.insert(newChild, childIndex);
        Collections.sort(this.children);
    }

    @Override
    public void add(MutableTreeNode newChild) {
        super.add(newChild);
        Collections.sort(this.children);
    }

    public void addUnsorted(MutableTreeNode newChild) {
        super.add(newChild);
    }

    public void insertAll(Collection<? extends MutableTreeNode> nodes) {
        this.insertAll(nodes, true);
    }

    public void insertAllUnsorted(Collection<? extends MutableTreeNode> nodes) {
        this.insertAll(nodes, false);
    }

    private void insertAll(Collection<? extends MutableTreeNode> nodes, boolean sortChildren) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        for (MutableTreeNode mutableTreeNode : nodes) {
            if (mutableTreeNode == null) {
                throw new NullPointerException("node == null");
            }
            if (this.isNodeAncestor(mutableTreeNode)) {
                throw new IllegalArgumentException("new child is an ancestor");
            }
            MutableTreeNode oldParent = (MutableTreeNode)mutableTreeNode.getParent();
            if (oldParent != null) {
                oldParent.remove(mutableTreeNode);
            }
            mutableTreeNode.setParent(this);
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.addAll(nodes);
        if (sortChildren) {
            this.sortChildren();
        }
    }

    @Override
    public int compareTo(Object o) {
        return collator.compare(this.toString(), o.toString());
    }
}

