/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jphototagger.api.preferences.Preferences;
import org.jphototagger.api.storage.Persistence;
import org.openide.util.Lookup;

public class SelectRootFilesPanel
extends JPanel
implements Persistence {
    private static final long serialVersionUID = 1L;
    private final Map<JCheckBox, File> ROOT_FILE_OF_CHECKBOX = new HashMap<JCheckBox, File>();
    private String persistenceKey = "SelectRootFilesPanel";
    private boolean listenToCheckBoxSelection = true;
    private final CheckBoxSelectionListener checkBoxSelectionListener = new CheckBoxSelectionListener();

    public SelectRootFilesPanel() {
        this.initComponents();
        this.addRootFileCheckboxes();
    }

    private void addRootFileCheckboxes() {
        File[] roots = File.listRoots();
        if (roots == null) {
            Logger.getLogger(SelectRootFilesPanel.class.getName()).log(Level.SEVERE, "No root files found");
            return;
        }
        int rootFileCount = roots.length;
        for (int index = 0; index < rootFileCount; ++index) {
            File rootFile = roots[index];
            String rootFilePath = rootFile.getAbsolutePath();
            JCheckBox rootFileCheckBox = new JCheckBox(rootFilePath);
            this.ROOT_FILE_OF_CHECKBOX.put(rootFileCheckBox, rootFile);
            this.add((Component)rootFileCheckBox, this.getCheckboxConstraints(index == rootFileCount - 1));
            rootFileCheckBox.addActionListener(this.checkBoxSelectionListener);
        }
    }

    private GridBagConstraints getCheckboxConstraints(boolean isLast) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.gridheight = isLast ? 0 : 1;
        gbc.weightx = 1.0;
        gbc.weighty = isLast ? 1.0 : 0.0;
        gbc.anchor = 18;
        return gbc;
    }

    public List<File> getSelectedRootFiles() {
        ArrayList<File> selectedRootFiles = new ArrayList<File>();
        Set<JCheckBox> checkBoxes = this.ROOT_FILE_OF_CHECKBOX.keySet();
        for (JCheckBox checkBox : checkBoxes) {
            if (!checkBox.isSelected()) continue;
            selectedRootFiles.add(this.ROOT_FILE_OF_CHECKBOX.get(checkBox));
        }
        return selectedRootFiles;
    }

    public void setPersistenceKey(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        this.persistenceKey = key;
    }

    public static List<File> readPersistentRootFiles(String key) {
        ArrayList<File> rootFiles = new ArrayList<File>();
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        List rootFilePaths = prefs.getStringCollection(key);
        for (String rootFilePath : rootFilePaths) {
            File rootFile = new File(rootFilePath);
            rootFiles.add(rootFile);
        }
        return rootFiles;
    }

    public void restore() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        List rootFilePaths = prefs.getStringCollection(this.persistenceKey);
        Set<JCheckBox> checkBoxes = this.ROOT_FILE_OF_CHECKBOX.keySet();
        boolean prevListenToCheckBoxSelection = this.listenToCheckBoxSelection;
        this.listenToCheckBoxSelection = false;
        for (JCheckBox checkBox : checkBoxes) {
            File rootFile = this.ROOT_FILE_OF_CHECKBOX.get(checkBox);
            String rootFilePath = rootFile.getAbsolutePath();
            boolean isSelected = rootFilePaths.contains(rootFilePath);
            checkBox.setSelected(isSelected);
        }
        this.listenToCheckBoxSelection = prevListenToCheckBoxSelection;
    }

    public void persist() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        List<File> selectedRootFiles = this.getSelectedRootFiles();
        ArrayList<String> selectedRootFilePaths = new ArrayList<String>(selectedRootFiles.size());
        prefs.removeKey(this.persistenceKey);
        for (File selectedRootFile : selectedRootFiles) {
            selectedRootFilePaths.add(selectedRootFile.getAbsolutePath());
        }
        prefs.setStringCollection(this.persistenceKey, selectedRootFilePaths);
    }

    private void initComponents() {
        this.setName("Form");
        this.setLayout(new GridBagLayout());
    }

    private class CheckBoxSelectionListener
    implements ActionListener {
        private CheckBoxSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectRootFilesPanel.this.listenToCheckBoxSelection) {
                return;
            }
            Object source = e.getSource();
            if (source instanceof JCheckBox) {
                SelectRootFilesPanel.this.persist();
            }
        }
    }
}

