/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.jphototagger.api.preferences.Preferences;
import org.openide.util.Lookup;

public final class SelectObjectsPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String DELIM_SEL_INDICES = ",";
    private final List<JCheckBox> checkBoxes = new ArrayList<JCheckBox>();
    private final Map<JCheckBox, Object> objectOfCheckBox = new LinkedHashMap<JCheckBox, Object>();
    private final Set<SelectionListener> listeners = new CopyOnWriteArraySet<SelectionListener>();
    private String preferencesKeyForSelectedIndices;
    private int componentCount;

    public SelectObjectsPanel() {
        this.init();
    }

    public SelectObjectsPanel(Properties properties, String preferencesKeyForSelectedIndices) {
        if (properties == null) {
            throw new NullPointerException("properties == null");
        }
        if (preferencesKeyForSelectedIndices == null) {
            throw new NullPointerException("keySelIndices == null");
        }
        this.preferencesKeyForSelectedIndices = preferencesKeyForSelectedIndices;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
    }

    public void addSelectionListener(SelectionListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(Object selObject) {
        SelectionEvent evt = new SelectionEvent(selObject, this.getSelectionCount());
        for (SelectionListener listener : this.listeners) {
            listener.objectSelected(evt);
        }
    }

    public void clear() {
        this.removeAll();
        this.checkBoxes.clear();
        this.objectOfCheckBox.clear();
        this.componentCount = -1;
    }

    public int getObjectCount() {
        return this.checkBoxes.size();
    }

    public int getSelectionCount() {
        int count = 0;
        for (JCheckBox checkBox : this.checkBoxes) {
            if (!checkBox.isSelected()) continue;
            ++count;
        }
        return count;
    }

    public void setPreferencesKeyForSelectedIndices(String preferencesKeyForSelectedIndices) {
        this.preferencesKeyForSelectedIndices = preferencesKeyForSelectedIndices;
    }

    public void add(Object object, String displayName) {
        if (object == null) {
            throw new NullPointerException("object == null");
        }
        if (displayName == null) {
            throw new NullPointerException("displayName == null");
        }
        this.addCheckBox(object, displayName);
    }

    public void setObjectCount(int count) {
        this.componentCount = count;
    }

    private void addCheckBox(Object object, String displayName) {
        JCheckBox checkBox = new JCheckBox(displayName);
        checkBox.addActionListener(this);
        this.checkBoxes.add(checkBox);
        this.objectOfCheckBox.put(checkBox, object);
        this.add((Component)checkBox, this.getGbcCheckBox());
    }

    private GridBagConstraints getGbcCheckBox() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = -1;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 1.0;
        if (this.componentCount > 0 && this.checkBoxes.size() == this.componentCount) {
            gbc.weighty = 1.0;
        }
        return gbc;
    }

    public List<Object> getSelectedObjects() {
        ArrayList<Object> selectedObjects = new ArrayList<Object>(this.objectOfCheckBox.size());
        for (JCheckBox checkBox : this.objectOfCheckBox.keySet()) {
            if (!checkBox.isSelected()) continue;
            selectedObjects.add(this.objectOfCheckBox.get(checkBox));
        }
        return selectedObjects;
    }

    public void restoreSelectedIndices() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs == null || !prefs.containsKey(this.preferencesKeyForSelectedIndices)) {
            return;
        }
        StringTokenizer st = new StringTokenizer(prefs.getString(this.preferencesKeyForSelectedIndices), DELIM_SEL_INDICES);
        int[] indices = new int[st.countTokens()];
        int i = 0;
        while (st.hasMoreElements()) {
            try {
                indices[i++] = Integer.parseInt(st.nextToken());
            }
            catch (NumberFormatException ex) {
                Logger.getLogger(SelectObjectsPanel.class.getName()).log(Level.SEVERE, null, ex);
                return;
            }
        }
        int size = this.checkBoxes.size();
        for (int index : indices) {
            if (index < 0 || index >= size) continue;
            this.checkBoxes.get(index).setSelected(true);
        }
    }

    public void setSelectedAll(boolean selected) {
        for (JCheckBox checkBox : this.checkBoxes) {
            checkBox.setSelected(selected);
        }
        this.persistSelectedIndices();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof JCheckBox) {
            this.persistSelectedIndices();
            this.notifyListeners(this.objectOfCheckBox.get((JCheckBox)source));
        }
    }

    private void persistSelectedIndices() {
        Preferences prefs = (Preferences)Lookup.getDefault().lookup(Preferences.class);
        if (prefs == null) {
            return;
        }
        int size = this.checkBoxes.size();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < size; ++i) {
            if (!this.checkBoxes.get(i).isSelected()) continue;
            sb.append(i == 0 ? "" : DELIM_SEL_INDICES);
            sb.append(Integer.toString(i));
        }
        prefs.setString(this.preferencesKeyForSelectedIndices, sb.toString());
    }

    public static interface SelectionListener {
        public void objectSelected(SelectionEvent var1);
    }

    public static class SelectionEvent {
        private final Object selectedObject;
        private final int selectionCount;

        public SelectionEvent(Object selectedObject, int selectionCount) {
            this.selectedObject = selectedObject;
            this.selectionCount = selectionCount;
        }

        public Object getSelectedObject() {
            return this.selectedObject;
        }

        public int getSelectionCount() {
            return this.selectionCount;
        }
    }
}

