/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;

public final class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final Set<ActionListener> actionListeners = new CopyOnWriteArraySet<ActionListener>();
    private boolean closeEnabled = true;
    private JButton buttonStop;
    private JLabel labelInfo;
    private JLabel labelProgressInfo;
    private JProgressBar progressBar;

    public ProgressDialog(Frame parent) {
        super(parent, false);
        this.initComponents();
    }

    public void addActionListener(ActionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.actionListeners.add(listener);
    }

    public void removeActionListener(ActionListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        this.actionListeners.remove(listener);
    }

    public void setValue(int value) {
        this.progressBar.setValue(value);
    }

    public void setMinimum(int minimum) {
        this.progressBar.setMinimum(minimum);
    }

    public void setMaximum(int maximum) {
        this.progressBar.setMaximum(maximum);
    }

    public void setInfoText(String text) {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        this.labelInfo.setText(text);
    }

    public void setCurrentProgressInfoText(String text) {
        if (text == null) {
            throw new NullPointerException("text == null");
        }
        this.labelProgressInfo.setText(text);
    }

    public void setIndeterminate(boolean indeterminate) {
        this.progressBar.setIndeterminate(indeterminate);
    }

    public void setStringPainted(boolean stringPainted) {
        this.progressBar.setStringPainted(stringPainted);
    }

    public void setProgressBarString(String string) {
        if (string == null) {
            throw new NullPointerException("string == null");
        }
        this.progressBar.setString(string);
    }

    public void setEnabledClose(boolean enabled) {
        this.closeEnabled = enabled;
    }

    public void setEnabledStop(boolean stop) {
        this.buttonStop.setEnabled(stop);
    }

    private void stop() {
        if (this.closeEnabled) {
            for (ActionListener listener : this.actionListeners) {
                listener.actionPerformed(new ActionEvent(this, 0, "Stop"));
            }
            this.setVisible(false);
        }
    }

    private void initComponents() {
        this.labelInfo = new JLabel();
        this.progressBar = new JProgressBar();
        this.buttonStop = new JButton();
        this.labelProgressInfo = new JLabel();
        this.setDefaultCloseOperation(0);
        ResourceBundle bundle = ResourceBundle.getBundle("org/jphototagger/lib/swing/Bundle");
        this.setTitle(bundle.getString("ProgressDialog.title"));
        this.setName("Form");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ProgressDialog.this.formWindowClosing(evt);
            }
        });
        this.labelInfo.setText("Info");
        this.labelInfo.setName("labelInfo");
        this.progressBar.setName("progressBar");
        this.buttonStop.setText(bundle.getString("ProgressDialog.buttonStop.text"));
        this.buttonStop.setName("buttonStop");
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ProgressDialog.this.buttonStopActionPerformed(evt);
            }
        });
        this.labelProgressInfo.setBorder(BorderFactory.createEtchedBorder());
        this.labelProgressInfo.setName("labelProgressInfo");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelProgressInfo, -1, 560, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.progressBar, -1, 493, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonStop)).addComponent(this.labelInfo, -1, 560, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.labelInfo, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonStop).addComponent(this.progressBar, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.labelProgressInfo, -1, 24, Short.MAX_VALUE).addContainerGap()));
        layout.linkSize(1, this.buttonStop, this.progressBar);
        this.pack();
    }

    private void buttonStopActionPerformed(ActionEvent evt) {
        this.stop();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.stop();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProgressDialog dialog = new ProgressDialog(new JFrame());
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

