/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.tree.TreePath;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.TreeItemTempSelectionRowSetter;
import org.jphototagger.lib.swing.util.TreeUtil;

public abstract class PopupMenuTree
extends JPopupMenu
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private final Map<JMenuItem, Collection<Listener>> listenersOfItem = new HashMap<JMenuItem, Collection<Listener>>();
    private JMenuItem itemCollapseExpandAllSubItems;
    private JMenuItem itemExpandAllSubItems;
    private List<TreePath> lastSelTreePaths;
    private final JTree tree;

    protected PopupMenuTree(JTree tree) {
        if (tree == null) {
            throw new NullPointerException("tree == null");
        }
        this.tree = tree;
        this.addMenuItems();
        this.listenToMenuItems(this);
        tree.addMouseListener(this);
        new TreeItemTempSelectionRowSetter(tree, this);
    }

    protected abstract void addMenuItems();

    private void listenToMenuItems(MenuElement menuElement) {
        if (menuElement instanceof JMenuItem) {
            ((JMenuItem)menuElement).addActionListener(this);
        }
        for (MenuElement subMenuElement : menuElement.getSubElements()) {
            this.listenToMenuItems(subMenuElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JMenuItem menuItem, Listener listener) {
        if (menuItem == null) {
            throw new NullPointerException("menuItem == null");
        }
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        Map<JMenuItem, Collection<Listener>> map = this.listenersOfItem;
        synchronized (map) {
            Collection<Listener> listeners = this.listenersOfItem.get(menuItem);
            if (listeners == null) {
                listeners = new HashSet<Listener>();
                this.listenersOfItem.put(menuItem, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(JMenuItem menuItem, Listener listener) {
        if (menuItem == null) {
            throw new NullPointerException("menuItem == null");
        }
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        Map<JMenuItem, Collection<Listener>> map = this.listenersOfItem;
        synchronized (map) {
            Collection<Listener> listeners = this.listenersOfItem.get(menuItem);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.listenersOfItem.remove(menuItem);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(JMenuItem menuItem) {
        Map<JMenuItem, Collection<Listener>> map = this.listenersOfItem;
        synchronized (map) {
            ArrayList<TreePath> paths = new ArrayList<TreePath>(this.lastSelTreePaths);
            for (Listener listener : this.listenersOfItem.get(menuItem)) {
                listener.action(this.tree, paths);
            }
        }
    }

    protected void setExpandAllSubItems(JMenuItem item) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        this.itemExpandAllSubItems = item;
    }

    protected void setCollapseAllSubItems(JMenuItem item) {
        if (item == null) {
            throw new NullPointerException("item == null");
        }
        this.itemCollapseExpandAllSubItems = item;
    }

    private void showPopupMenu(MouseEvent evt) {
        if (this.setLastSelTreePaths(evt)) {
            this.setMenuItemsEnabled(new ArrayList<TreePath>(this.lastSelTreePaths));
            this.show(this.tree, evt.getX(), evt.getY());
        }
    }

    private boolean setLastSelTreePaths(MouseEvent evt) {
        TreePath mouseCursorPath = TreeUtil.getTreePath(evt);
        if (mouseCursorPath == null) {
            return false;
        }
        if (this.tree.isPathSelected(mouseCursorPath)) {
            this.setAllSelectedTreePaths();
        } else {
            this.lastSelTreePaths = Collections.singletonList(mouseCursorPath);
        }
        return true;
    }

    private void setAllSelectedTreePaths() {
        this.lastSelTreePaths = Arrays.asList(this.tree.getSelectionPaths());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JMenuItem menuItem;
        Object source = evt.getSource();
        if (source == this.itemExpandAllSubItems) {
            TreeUtil.expandAll(this.tree, this.lastSelTreePaths, true);
        } else if (source == this.itemCollapseExpandAllSubItems) {
            TreeUtil.expandAll(this.tree, this.lastSelTreePaths, false);
        } else if (source instanceof JMenuItem && this.listenersOfItem.containsKey(menuItem = (JMenuItem)source)) {
            this.notifyListeners(menuItem);
        }
    }

    protected void setMenuItemsEnabled(List<TreePath> selTreePaths) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!MouseEventUtil.isPopupTrigger(evt)) {
            return;
        }
        if (evt.getSource() == this.tree) {
            this.showPopupMenu(evt);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    public static interface Listener {
        public void action(JTree var1, List<TreePath> var2);
    }
}

