/*
 * Decompiled with CFR 0.152.
 */
package org.jphototagger.lib.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.jphototagger.lib.swing.MouseEventUtil;
import org.jphototagger.lib.swing.util.ListItemTempSelectionRowSetter;
import org.jphototagger.lib.swing.util.ListUtil;

public abstract class PopupMenuList
extends JPopupMenu
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = 1L;
    private final Map<JMenuItem, Collection<Listener>> listenersOfItem = new HashMap<JMenuItem, Collection<Listener>>();
    private List<Object> lastSelValues;
    private final JList<?> list;

    protected PopupMenuList(JList<?> list) {
        if (list == null) {
            throw new NullPointerException("list == null");
        }
        this.list = list;
        this.addMenuItems();
        this.listenToMenuItems(this);
        list.addMouseListener(this);
        new ListItemTempSelectionRowSetter(list, this);
    }

    protected abstract void addMenuItems();

    private void listenToMenuItems(MenuElement menuElement) {
        if (menuElement instanceof JMenuItem) {
            ((JMenuItem)menuElement).addActionListener(this);
        }
        for (MenuElement subMenuElement : menuElement.getSubElements()) {
            this.listenToMenuItems(subMenuElement);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(JMenuItem menuItem, Listener listener) {
        if (menuItem == null) {
            throw new NullPointerException("menuItem == null");
        }
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        Map<JMenuItem, Collection<Listener>> map = this.listenersOfItem;
        synchronized (map) {
            Collection<Listener> listeners = this.listenersOfItem.get(menuItem);
            if (listeners == null) {
                listeners = new HashSet<Listener>();
                this.listenersOfItem.put(menuItem, listeners);
            }
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(JMenuItem menuItem, Listener listener) {
        if (menuItem == null) {
            throw new NullPointerException("menuItem == null");
        }
        if (listener == null) {
            throw new NullPointerException("listener == null");
        }
        Map<JMenuItem, Collection<Listener>> map = this.listenersOfItem;
        synchronized (map) {
            Collection<Listener> listeners = this.listenersOfItem.get(menuItem);
            if (listeners != null) {
                listeners.remove(listener);
                if (listeners.isEmpty()) {
                    this.listenersOfItem.remove(menuItem);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(JMenuItem menuItem) {
        Map<JMenuItem, Collection<Listener>> map = this.listenersOfItem;
        synchronized (map) {
            ArrayList<Object> paths = new ArrayList<Object>(this.lastSelValues);
            for (Listener listener : this.listenersOfItem.get(menuItem)) {
                listener.action(this.list, paths);
            }
        }
    }

    private void showPopupMenu(MouseEvent evt) {
        if (this.setLastSelValues(evt)) {
            this.setMenuItemsEnabled(new ArrayList<Object>(this.lastSelValues));
            this.show(this.list, evt.getX(), evt.getY());
        }
    }

    private boolean setLastSelValues(MouseEvent evt) {
        int mouseCursorIndex = ListUtil.getItemIndex(evt);
        if (mouseCursorIndex < 0) {
            return false;
        }
        if (this.list.isSelectedIndex(mouseCursorIndex)) {
            this.setAllSelectedListItems();
        } else {
            this.lastSelValues = Collections.singletonList(this.list.getSelectedValue());
        }
        return true;
    }

    private void setAllSelectedListItems() {
        this.lastSelValues = new ArrayList(this.list.getSelectedValuesList());
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        JMenuItem menuItem;
        Object source = evt.getSource();
        if (source instanceof JMenuItem && this.listenersOfItem.containsKey(menuItem = (JMenuItem)source)) {
            this.notifyListeners(menuItem);
        }
    }

    protected void setMenuItemsEnabled(List<Object> selListValues) {
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        if (!MouseEventUtil.isPopupTrigger(evt)) {
            return;
        }
        if (evt.getSource() == this.list) {
            this.showPopupMenu(evt);
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseExited(MouseEvent evt) {
    }

    public static interface Listener {
        public void action(JList<?> var1, List<Object> var2);
    }
}

